/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet;

import io.github.dsheirer.bits.MessageFramer;
import io.github.dsheirer.bits.SyncPattern;
import io.github.dsheirer.dsp.fsk.LTRDecoder;
import io.github.dsheirer.message.MessageDirection;
import io.github.dsheirer.module.decode.Decoder;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.ltrnet.DecodeConfigLTRNet;
import io.github.dsheirer.module.decode.ltrnet.LTRNetMessageProcessor;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.real.IRealBufferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTRNetDecoder
extends Decoder
implements IRealBufferListener,
Listener<float[]> {
    private static final Logger mLog = LoggerFactory.getLogger(LTRNetDecoder.class);
    public static final int LTR_NET_MESSAGE_LENGTH = 40;
    protected LTRDecoder mLTRDecoder;
    private MessageFramer mLTRMessageFramer;
    private LTRNetMessageProcessor mLTRMessageProcessor;

    public LTRNetDecoder(DecodeConfigLTRNet config, LTRDecoder ltrDecoder) {
        this.mLTRDecoder = ltrDecoder;
        this.mLTRMessageFramer = config.getMessageDirection() == MessageDirection.OSW ? new MessageFramer(SyncPattern.LTR_STANDARD_OSW.getPattern(), 40) : new MessageFramer(SyncPattern.LTR_STANDARD_ISW.getPattern(), 40);
        this.mLTRDecoder.setListener(bits -> {
            for (boolean bit : bits) {
                this.mLTRMessageFramer.process(bit);
            }
        });
        this.mLTRMessageProcessor = new LTRNetMessageProcessor(config.getMessageDirection());
        this.mLTRMessageFramer.addMessageListener(this.mLTRMessageProcessor);
        this.mLTRMessageProcessor.setMessageListener(this.getMessageListener());
    }

    public LTRNetDecoder(DecodeConfigLTRNet config) {
        this(config, new LTRDecoder());
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.LTR_NET;
    }

    @Override
    public Listener<float[]> getBufferListener() {
        return this.mLTRDecoder;
    }

    @Override
    public void receive(float[] demodulatedSamples) {
        this.mLTRDecoder.receive(demodulatedSamples);
    }

    @Override
    public void reset() {
        this.mLTRMessageFramer.reset();
    }
}

