/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.lj1200;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.protocol.Protocol;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LJ1200TransponderMessage
extends Message {
    private static final Logger mLog = LoggerFactory.getLogger(LJ1200TransponderMessage.class);
    public static int[] SYNC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    public static int[] MESSAGE_CRC = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private static SimpleDateFormat mSDF = new SimpleDateFormat("yyyyMMdd HHmmss");
    private CorrectedBinaryMessage mMessage;
    private CRC mCRC;

    public LJ1200TransponderMessage(CorrectedBinaryMessage message) {
        this.mMessage = message;
        this.checkCRC();
        switch (this.mCRC) {
            case CORRECTED: {
                mLog.debug("CORR:" + message.toString());
                break;
            }
            case FAILED_CRC: {
                mLog.debug("FAIL:" + message.toString());
                break;
            }
            case PASSED: {
                mLog.debug("PASS:" + message.toString());
                break;
            }
            case UNKNOWN: {
                mLog.debug("UNKNOWN:" + message.toString());
                break;
            }
        }
    }

    private void checkCRC() {
        this.mCRC = CRC.UNKNOWN;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public String getCRC() {
        return this.mMessage.getHex(MESSAGE_CRC, 4);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TRANSPONDER TEST");
        return sb.toString();
    }

    public String pad(String value, int places, String padCharacter) {
        return StringUtils.rightPad((String)value, (int)places, (String)padCharacter);
    }

    public String format(int number, int decimalPlaces) {
        return StringUtils.leftPad((String)Integer.valueOf(number).toString(), (int)decimalPlaces, (char)'0');
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.LOJACK;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.EMPTY_LIST;
    }
}

