/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.lj1200;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.lj1200.LJ1200Message;
import io.github.dsheirer.module.decode.lj1200.LJ1200TransponderMessage;
import java.util.function.Function;

public class LJ1200MessageFilter
extends Filter<IMessage, String> {
    private static final String LJ1200_KEY = "LJ-1200";
    private final LJ1200KeyExtractor mKeyExtractor = new LJ1200KeyExtractor(this);

    public LJ1200MessageFilter() {
        super("LJ-1200 Messages");
        this.add(new FilterElement<String>(LJ1200_KEY));
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof LJ1200Message || message instanceof LJ1200TransponderMessage;
    }

    @Override
    public Function<IMessage, String> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    public class LJ1200KeyExtractor
    implements Function<IMessage, String> {
        public LJ1200KeyExtractor(LJ1200MessageFilter this$0) {
        }

        @Override
        public String apply(IMessage message) {
            return LJ1200MessageFilter.LJ1200_KEY;
        }
    }
}

