/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.lj1200;

import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.lj1200.LJ1200Message;
import io.github.dsheirer.module.decode.lj1200.LJ1200TransponderMessage;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LJ1200DecoderState
extends DecoderState {
    private static final Logger mLog = LoggerFactory.getLogger(LJ1200DecoderState.class);
    private Set<String> mAddresses = new TreeSet<String>();

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.LJ_1200;
    }

    @Override
    public void receive(IMessage message) {
        if (message instanceof LJ1200Message) {
            LJ1200Message lj = (LJ1200Message)message;
            if (lj.isValid()) {
                String address = lj.getAddress();
                this.mAddresses.add(address);
                MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
                ic.remove(IdentifierClass.USER);
                ic.update(lj.getIdentifiers());
                DecodeEvent event = DecodeEvent.builder(DecodeEventType.DATA_PACKET, System.currentTimeMillis()).protocol(Protocol.LOJACK).identifiers(ic).channel(this.getCurrentChannel()).details("LOJACK " + String.valueOf(lj)).build();
                this.broadcast(event);
                this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.DATA));
            }
        } else if (message instanceof LJ1200TransponderMessage) {
            LJ1200TransponderMessage transponder = (LJ1200TransponderMessage)message;
            MutableIdentifierCollection ic = new MutableIdentifierCollection(this.getIdentifierCollection().getIdentifiers());
            ic.remove(IdentifierClass.USER);
            ic.update(transponder.getIdentifiers());
            DecodeEvent transponderEvent = DecodeEvent.builder(DecodeEventType.GPS, System.currentTimeMillis()).protocol(Protocol.LOJACK).identifiers(ic).channel(this.getCurrentChannel()).details("LOJACK TRANSPONDER " + String.valueOf(transponder)).build();
            this.broadcast(transponderEvent);
        }
    }

    @Override
    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("=============================\n");
        sb.append("Decoder:\tLJ-1200I\n\n");
        if (!this.mAddresses.isEmpty()) {
            sb.append("Transponder Addresses:\n");
            ArrayList<String> addresses = new ArrayList<String>(this.mAddresses);
            Collections.sort(addresses);
            for (String address : addresses) {
                sb.append("\t");
                sb.append(address);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        if (event.getEvent() == DecoderStateEvent.Event.REQUEST_RESET) {
            this.resetState();
        }
    }

    @Override
    protected void resetState() {
        super.resetState();
    }

    @Override
    public void reset() {
        super.reset();
        this.mAddresses.clear();
        this.resetState();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void init() {
    }
}

