/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.lj1200;

import io.github.dsheirer.bits.IBinarySymbolProcessor;
import io.github.dsheirer.bits.MessageFramer;
import io.github.dsheirer.bits.SyncPattern;
import io.github.dsheirer.dsp.afsk.AFSK1200Decoder;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.afsk.AbstractAFSKDecoder;
import io.github.dsheirer.module.decode.lj1200.LJ1200MessageProcessor;

public class LJ1200Decoder
extends AbstractAFSKDecoder
implements IBinarySymbolProcessor {
    private static final int MESSAGE_LENGTH = 80;
    private MessageFramer mTowerMessageFramer;
    private MessageFramer mTransponderMessageFramer;
    private LJ1200MessageProcessor mMessageProcessor;

    protected LJ1200Decoder(AFSK1200Decoder decoder) {
        super(decoder);
        this.init();
    }

    public LJ1200Decoder() {
        super(AFSK1200Decoder.Output.NORMAL);
        this.init();
    }

    private void init() {
        this.getDecoder().setSymbolProcessor(this);
        this.mTowerMessageFramer = new MessageFramer(SyncPattern.LJ1200.getPattern(), 80);
        this.mTransponderMessageFramer = new MessageFramer(SyncPattern.LJ1200_TRANSPONDER.getPattern(), 80);
        this.mMessageProcessor = new LJ1200MessageProcessor();
        this.mTowerMessageFramer.addMessageListener(this.mMessageProcessor);
        this.mTransponderMessageFramer.addMessageListener(this.mMessageProcessor);
        this.mMessageProcessor.setMessageListener(this.getMessageListener());
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.LJ_1200;
    }

    @Override
    public void process(boolean symbol) {
        this.mTowerMessageFramer.process(symbol);
        this.mTransponderMessageFramer.process(symbol);
    }

    public MessageFramer getTowerMessageFramer() {
        return this.mTowerMessageFramer;
    }

    public MessageFramer getTransponderMessageFramer() {
        return this.mTransponderMessageFramer;
    }
}

