/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.xcmp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.Packet;
import io.github.dsheirer.module.decode.ip.mototrbo.xcmp.XCMPHeader;
import io.github.dsheirer.module.decode.ip.mototrbo.xcmp.XCMPPacketFactory;
import java.util.List;

public class XCMPPacket
extends Packet {
    private XCMPHeader mHeader;
    private IPacket mPayload;

    public XCMPPacket(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHeader());
        sb.append(" ").append(this.getPayload());
        return sb.toString();
    }

    @Override
    public XCMPHeader getHeader() {
        if (this.mHeader == null) {
            this.mHeader = new XCMPHeader(this.getMessage(), this.getOffset());
        }
        return this.mHeader;
    }

    @Override
    public IPacket getPayload() {
        if (this.mPayload == null) {
            this.mPayload = XCMPPacketFactory.create(this.getMessage(), this.getOffset() + this.getHeader().getLength(), this.getHeader().getMessageType());
        }
        return this.mPayload;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.getHeader().getIdentifiers();
    }
}

