/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.xcmp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.identifier.DMRNetwork;
import io.github.dsheirer.module.decode.dmr.identifier.DMRSite;

public class Repeater {
    private static int[] SITE = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static int[] REPEATER_ID = new int[]{8, 9, 10, 11};
    private static int CONTROL_CHANNEL_FLAG = 12;
    private static int[] UPLINK_FREQUENCY = new int[]{13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static int[] COLOR_CODE = new int[]{40, 41, 42, 43};
    private static int RESERVED = 44;
    private static int[] DOWNLINK_FREQUENCY = new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private CorrectedBinaryMessage mMessage;
    private int mOffset;
    private DMRNetwork mDMRNetwork;
    private DMRSite mSite;

    public Repeater(CorrectedBinaryMessage message, int offset, DMRNetwork dmrNetwork) {
        this.mMessage = message;
        this.mOffset = offset;
        this.mDMRNetwork = dmrNetwork;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("REPEATER:").append(this.getNetwork()).append(".").append(this.getSite()).append(".").append(this.getRepeaterNumber());
        sb.append(" CC:").append(this.getColorCode());
        sb.append(" DN:").append((double)this.getDownlinkFrequency() / 1000000.0);
        sb.append(" UP:").append((double)this.getUplinkFrequency() / 1000000.0);
        if (this.isControlChannel()) {
            sb.append(" CONTROL");
        }
        return sb.toString();
    }

    public DMRNetwork getNetwork() {
        return this.mDMRNetwork;
    }

    private CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    private int getOffset() {
        return this.mOffset;
    }

    public boolean isValid() {
        return this.getDownlinkFrequency() != this.getUplinkFrequency();
    }

    public int getColorCode() {
        return this.getMessage().getInt(COLOR_CODE, this.getOffset());
    }

    public long getUplinkFrequency() {
        return (long)this.getMessage().getInt(UPLINK_FREQUENCY, this.getOffset()) * 10L;
    }

    public long getDownlinkFrequency() {
        return (long)this.getMessage().getInt(DOWNLINK_FREQUENCY, this.getOffset()) * 10L;
    }

    public boolean isControlChannel() {
        return this.getMessage().get(CONTROL_CHANNEL_FLAG + this.getOffset());
    }

    public int getRepeaterNumber() {
        return this.getMessage().getInt(REPEATER_ID, this.getOffset()) + 1;
    }

    public DMRSite getSite() {
        if (this.mSite == null) {
            this.mSite = DMRSite.create(this.getMessage().getInt(SITE, this.getOffset()));
        }
        return this.mSite;
    }
}

