/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.xcmp;

import com.google.common.base.Joiner;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.identifier.DMRNetwork;
import io.github.dsheirer.module.decode.ip.IHeader;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.Packet;
import io.github.dsheirer.module.decode.ip.mototrbo.xcmp.Repeater;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NetworkFrequencyFile
extends Packet {
    private static final int[] VERSION = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] SEGMENT_NUMBER = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] SEGMENT_COUNT = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] NETWORK = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59};
    private static final int[] UNKNOWN = new int[]{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private static final int REPEATER_STRUCTURE_START = 80;
    private static final int REPEATER_STRUCTURE_LENGTH = 72;
    private List<Repeater> mRepeaters;
    private DMRNetwork mNetwork;

    public NetworkFrequencyFile(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NETWORK FREQUENCY FILE VERSION:").append(this.getVersion());
        sb.append(" NETWORK:").append(this.getNetwork());
        sb.append(" SEGMENT:").append(this.getSegmentNumber()).append(" OF ").append(this.getSegmentCount());
        List<Repeater> repeaters = this.getRepeaters();
        if (repeaters.isEmpty()) {
            sb.append(" NO REPEATER INFO");
        } else {
            sb.append(" ").append(Joiner.on((String)" | ").join(this.mRepeaters));
        }
        return sb.toString();
    }

    public DMRNetwork getNetwork() {
        if (this.mNetwork == null) {
            this.mNetwork = DMRNetwork.create(this.getMessage().getInt(NETWORK, this.getOffset()));
        }
        return this.mNetwork;
    }

    public String getUnknown() {
        return String.format("%05X", this.getMessage().getInt(UNKNOWN, this.getOffset()));
    }

    public int getSegmentNumber() {
        return this.getMessage().getInt(SEGMENT_NUMBER, this.getOffset());
    }

    public int getSegmentCount() {
        return this.getMessage().getInt(SEGMENT_COUNT, this.getOffset());
    }

    public List<Repeater> getRepeaters() {
        if (this.mRepeaters == null) {
            this.mRepeaters = new ArrayList<Repeater>();
            int offset = this.getOffset() + 80;
            for (int x = 0; x < 15; ++x) {
                if (offset > this.getMessage().length()) continue;
                Repeater repeater = new Repeater(this.getMessage(), offset, this.getNetwork());
                if (repeater.isValid()) {
                    this.mRepeaters.add(repeater);
                }
                offset += 72;
            }
        }
        return this.mRepeaters;
    }

    public int getVersion() {
        return this.getMessage().getInt(VERSION, this.getOffset());
    }

    @Override
    public IHeader getHeader() {
        return null;
    }

    @Override
    public IPacket getPayload() {
        return null;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

