/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum TokenType {
    IDENTITY("22", -1, "IDENTITY"),
    UNKNOWN_23("23", 1, "UNKNOWN 23"),
    TRIGGER_PERIODIC("31", 1, "TRIGGER PERIODIC"),
    TIMESTAMP("34", 5, "TIMESTAMP"),
    VERSION("36", 1, "VERSION"),
    RESPONSE("37", -1, "RESPONSE"),
    SUCCESS("38", 0, "SUCCESS"),
    REQUEST_3A("3A", 0, "REQUEST-3A"),
    TRIGGER_GPIO("42", 0, "TRIGGER GPIO"),
    TRIGGER_DISTANCE("4A", 1, "TRIGGER DISTANCE"),
    ALTITUDE_ACCURACY("50", 0, "ALTITUDE ACCURACY"),
    CIRCLE_2D("51", 10, "CIRCLE 2D"),
    TIME("52", 0, "TIME"),
    ALTITUDE("54", 0, "ALTITUDE"),
    CIRCLE_3D("55", 15, "CIRCLE 3D"),
    HEADING("56", 1, "HEADING"),
    HORIZONTAL_DIRECTION("57", 0, "HORIZONTAL DIRECTION"),
    REQUEST_61("61", 1, "REQUEST-61"),
    REQUEST_62("62", 0, "REQUEST-62"),
    REQUEST_64("64", 0, "REQUEST-64"),
    POINT_2D("66", 8, "POINT 2D"),
    POINT_3D("69", 11, "POINT 3D"),
    SPEED("6C", 2, "SPEED"),
    REQUEST_73("73", 1, "REQUEST-73"),
    TRIGGER_ON_MOVE("78", 1, "TRIGGER ON MOVE"),
    REQUESTED_TOKENS("000", 0, "REQUESTED TOKENS"),
    UNKNOWN("0", 0, "UNKNOWN");

    private String mValue;
    private int mLength;
    private String mLabel;
    private static EnumSet<TokenType> REQUEST_PARAMETER_TOKENS;
    private static final Map<String, TokenType> LOOKUP_MAP;

    private TokenType(String value, int length, String label) {
        this.mValue = value;
        this.mLength = length;
        this.mLabel = label;
    }

    public String getValue() {
        return this.mValue;
    }

    public boolean isVariableLength() {
        return this.mLength == -1;
    }

    public int getLength() {
        return this.mLength;
    }

    public boolean isRequestParameterToken() {
        return REQUEST_PARAMETER_TOKENS.contains((Object)this);
    }

    public static TokenType fromValue(String value) {
        if (value != null && LOOKUP_MAP.containsKey(value)) {
            return LOOKUP_MAP.get(value);
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.mLabel;
    }

    static {
        REQUEST_PARAMETER_TOKENS = EnumSet.of(IDENTITY, new TokenType[]{TRIGGER_DISTANCE, TRIGGER_GPIO, TRIGGER_ON_MOVE, TRIGGER_PERIODIC, REQUEST_61, REQUEST_73});
        LOOKUP_MAP = new HashMap<String, TokenType>();
        for (TokenType tokenType : TokenType.values()) {
            LOOKUP_MAP.put(tokenType.getValue(), tokenType);
        }
    }
}

