/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Circle2d;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Circle3d;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Heading;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Identity;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Point2d;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Point3d;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Request61;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Request73;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Response;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Speed;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Success;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Timestamp;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Token;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TokenType;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TriggerDistance;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TriggerGpio;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TriggerOnMove;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TriggerPeriodic;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Unknown23;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.UnknownToken;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Version;

public class TokenFactory {
    public static Token createToken(String id, CorrectedBinaryMessage message, int offset, int remainingCharacterCount) {
        TokenType tokenType = TokenType.fromValue(id);
        switch (tokenType) {
            case HEADING: {
                return new Heading(message, offset);
            }
            case IDENTITY: {
                return new Identity(message, offset);
            }
            case POINT_2D: {
                return new Point2d(message, offset);
            }
            case CIRCLE_2D: {
                return new Circle2d(message, offset);
            }
            case POINT_3D: {
                return new Point3d(message, offset);
            }
            case CIRCLE_3D: {
                return new Circle3d(message, offset);
            }
            case RESPONSE: {
                return new Response(message, offset);
            }
            case SPEED: {
                return new Speed(message, offset);
            }
            case SUCCESS: {
                return new Success(message, offset);
            }
            case TIMESTAMP: {
                return new Timestamp(message, offset);
            }
            case TRIGGER_DISTANCE: {
                return new TriggerDistance(message, offset);
            }
            case TRIGGER_GPIO: {
                return new TriggerGpio(message, offset);
            }
            case TRIGGER_ON_MOVE: {
                return new TriggerOnMove(message, offset);
            }
            case TRIGGER_PERIODIC: {
                return new TriggerPeriodic(message, offset);
            }
            case VERSION: {
                return new Version(message, offset);
            }
            case UNKNOWN_23: {
                return new Unknown23(message, offset);
            }
            case REQUEST_61: {
                return new Request61(message, offset);
            }
            case REQUEST_73: {
                return new Request73(message, offset);
            }
        }
        return new UnknownToken(message, offset, remainingCharacterCount);
    }
}

