/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TokenType;

public abstract class Token {
    private static final int[] VARIABLE_LENGTH_BYTE_COUNT = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private CorrectedBinaryMessage mMessage;
    private int mOffset;

    public Token(CorrectedBinaryMessage message, int offset) {
        this.mMessage = message;
        this.mOffset = offset;
    }

    protected CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    protected int getOffset() {
        return this.mOffset;
    }

    public abstract TokenType getTokenType();

    public int getVariableLengthPayloadSize() {
        return this.getMessage().getInt(VARIABLE_LENGTH_BYTE_COUNT, this.getOffset());
    }

    public int getByteLength() {
        if (this.getTokenType().isVariableLength()) {
            return this.getVariableLengthPayloadSize() + 2;
        }
        return this.getTokenType().getLength() + 1;
    }
}

