/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Token;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TokenType;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Timestamp
extends Token {
    private static final int[] YEAR = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21};
    private static final int[] MONTH = new int[]{22, 23, 24, 25};
    private static final int[] DAY = new int[]{26, 27, 28, 29, 30};
    private static final int[] HOUR = new int[]{31, 32, 33, 34, 35};
    private static final int[] MINUTE = new int[]{36, 37, 38, 39, 40, 41};
    private static final int[] SECOND = new int[]{42, 43, 44, 45, 46, 47};

    public Timestamp(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.TIMESTAMP;
    }

    public long getTimestamp() {
        int year = this.getMessage().getInt(YEAR, this.getOffset());
        int month = this.getMessage().getInt(MONTH, this.getOffset()) - 1;
        int day = this.getMessage().getInt(DAY, this.getOffset());
        int hour = this.getMessage().getInt(HOUR, this.getOffset());
        int minute = this.getMessage().getInt(MINUTE, this.getOffset());
        int second = this.getMessage().getInt(SECOND, this.getOffset());
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.set(year, month, day, hour, minute, second);
        return calendar.getTimeInMillis();
    }

    public String toString() {
        return "TIME:" + new Date(this.getTimestamp()).toString().toUpperCase();
    }
}

