/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token;

import com.google.common.base.Joiner;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Token;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TokenType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RequestedTokens
extends Token {
    private List<TokenType> mRequestedTokens = new ArrayList<TokenType>();
    private List<String> mUnrecognizedRequestedTokens = new ArrayList<String>();

    public RequestedTokens() {
        super(null, 0);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.REQUESTED_TOKENS;
    }

    public void add(TokenType tokenType) {
        this.mRequestedTokens.add(tokenType);
    }

    public void add(String unrecognizedTokenType) {
        this.mUnrecognizedRequestedTokens.add(unrecognizedTokenType);
        Collections.sort(this.mUnrecognizedRequestedTokens);
    }

    public boolean hasRequestedTokens() {
        return !this.mRequestedTokens.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("REQUESTED TOKENS [");
        if (!this.mRequestedTokens.isEmpty()) {
            sb.append(Joiner.on((String)",").join(this.mRequestedTokens));
        }
        if (!this.mRequestedTokens.isEmpty() && !this.mUnrecognizedRequestedTokens.isEmpty()) {
            sb.append(",");
        }
        if (!this.mUnrecognizedRequestedTokens.isEmpty()) {
            sb.append("UNRECOGNIZED(").append(Joiner.on((String)",").join(this.mUnrecognizedRequestedTokens)).append(")");
        }
        sb.append("]");
        return sb.toString();
    }
}

