/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.LRRPPosition;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Token;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TokenType;

public class Point2d
extends Token {
    private static final int LATITUDE_HEMISPHERE_FLAG = 8;
    private static final int[] LATITUDE = new int[]{9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] LONGITUDE = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private static final double LATITUDE_MULTIPLIER = 4.190951586745435E-8;
    private static final double LONGITUDE_MULTIPLIER = 8.38190317349087E-8;
    protected static final float HUNDREDTHS_MULTIPLIER = 0.01f;
    private LRRPPosition mPosition;

    public Point2d(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.POINT_2D;
    }

    public LRRPPosition getPosition() {
        if (this.mPosition == null) {
            this.mPosition = LRRPPosition.createFrom(this.getLatitude(), this.getLongitude());
        }
        return this.mPosition;
    }

    public double getLatitude() {
        return (double)this.getMessage().getInt(LATITUDE, this.getOffset()) * 4.190951586745435E-8 * (double)(this.getMessage().get(this.getOffset() + 8) ? -1 : 1);
    }

    public double getLongitude() {
        return (double)this.getMessage().getInt(LONGITUDE, this.getOffset()) * 8.38190317349087E-8;
    }

    public String toString() {
        return "POINT:" + String.valueOf(this.getPosition());
    }
}

