/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.Token;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.token.TokenType;

public class Identity
extends Token {
    private static final int IDENTIFIER_START = 16;
    private static final int[] BYTE_VALUE = new int[]{0, 1, 2, 3, 4, 5, 6, 7};

    public Identity(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.IDENTITY;
    }

    private BinaryMessage getTokenContents() {
        return this.getMessage().getSubMessage(this.getOffset(), this.getOffset() + 48);
    }

    public int getID() {
        int payloadOffset = 16;
        int value = 0;
        for (int length = this.getVariableLengthPayloadSize(); 0 < length && length <= 4; --length) {
            int byteValue = this.getMessage().getInt(BYTE_VALUE, this.getOffset() + payloadOffset);
            byteValue = Integer.rotateLeft(byteValue, payloadOffset - 16);
            value += byteValue;
            payloadOffset += 8;
        }
        return value;
    }

    public String toString() {
        int id = this.getID();
        if (id != 0) {
            return "ID:" + id;
        }
        return "ID:" + this.getTokenContents().toHexString();
    }
}

