/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.lrrp;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.Header;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.LRRPPacketType;
import java.util.Collections;
import java.util.List;

public class LRRPHeader
extends Header {
    private static final int[] TYPE = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] LENGTH = new int[]{8, 9, 10, 11, 12, 13, 14, 15};

    public LRRPHeader(BinaryMessage message, int offset) {
        super(message, offset);
    }

    private void checkValid() {
        this.setValid(this.getMessage().size() >= this.getOffset() + this.getLength() + this.getPayloadLength());
    }

    public int getLrrpPacketTypeValue() {
        return this.getMessage().getInt(TYPE, this.getOffset());
    }

    public LRRPPacketType getLRRPPacketType() {
        return LRRPPacketType.fromValue(this.getLrrpPacketTypeValue());
    }

    public int getPayloadLength() {
        return this.getMessage().getInt(LENGTH, this.getOffset());
    }

    @Override
    public int getLength() {
        return 16;
    }

    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

