/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.ars;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSHeader;
import java.util.Collections;
import java.util.List;

public class UserRegistrationAcknowledge
extends ARSHeader {
    private static final int[] SESSION_TIME_OR_REASON = new int[]{25, 26, 27, 28, 29, 30, 31};

    public UserRegistrationAcknowledge(BinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isSuccessful()) {
            sb.append("USER REGISTRATION SUCCESS - SESSION TIME:").append(this.getSessionTime());
        } else {
            sb.append("USER REGISTRATION FAILED - REASON:").append(this.getFailureReason());
        }
        return sb.toString();
    }

    public boolean isSuccessful() {
        return !this.isAcknowledge();
    }

    public int getSessionTime() {
        if (this.hasHeaderExtension()) {
            return this.getMessage().getInt(SESSION_TIME_OR_REASON, this.getOffset());
        }
        return 0;
    }

    public String getFailureReason() {
        if (this.hasHeaderExtension()) {
            int reason = this.getMessage().getInt(SESSION_TIME_OR_REASON, this.getOffset());
            switch (reason) {
                case 1: {
                    return "USER VALIDATION FAILED";
                }
                case 2: {
                    return "USER VALIDATION TIMEOUT";
                }
            }
            return "TRANSMISSION FAILURE";
        }
        return "NONE";
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

