/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.ars;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSHeader;
import java.util.Collections;
import java.util.List;

public class RegistrationAcknowledgement
extends ARSHeader {
    private static final int[] TIMER_OR_REASON = new int[]{25, 26, 27, 28, 29, 30, 31};

    public RegistrationAcknowledgement(BinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isValid()) {
            sb.append("REGISTRATION ");
            if (this.isSuccessful()) {
                sb.append("SUCCESS");
                int units = this.getPayloadValue();
                sb.append(" REFRESH IN:").append(units * 30).append("mins");
            } else {
                sb.append("FAIL");
                int units = this.getPayloadValue();
                if (units == 0) {
                    sb.append(" - UNAUTHORIZED DEVICE");
                } else {
                    sb.append(" REASON:").append(units);
                }
            }
        } else {
            sb.append("REGISTRATION ACKNOWLEDGE - ERROR - INVALID MESSAGE LENGTH");
        }
        return sb.toString();
    }

    public boolean isSuccessful() {
        return !this.isAcknowledge();
    }

    public int getPayloadValue() {
        return this.getMessage().getInt(TIMER_OR_REASON, this.getOffset());
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

