/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.mototrbo.ars;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSHeader;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSPDUType;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.DeviceDeRegistration;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.DeviceRegistration;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.QueryMessage;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.RegistrationAcknowledgement;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.UnknownARSHeader;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.UserDeRegistration;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.UserRegistration;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.UserRegistrationAcknowledge;

public class ARSHeaderFactory {
    public static ARSHeader create(ARSPDUType pduType, BinaryMessage message, int offset) {
        switch (pduType) {
            case DEVICE_REGISTRATION: {
                return new DeviceRegistration(message, offset);
            }
            case DEVICE_DEREGISTRATION: {
                return new DeviceDeRegistration(message, offset);
            }
            case QUERY: {
                return new QueryMessage(message, offset);
            }
            case USER_REGISTRATION: {
                return new UserRegistration(message, offset);
            }
            case USER_DEREGISTRATION: {
                return new UserDeRegistration(message, offset);
            }
            case USER_REGISTRATION_ACKNOWLEDGEMENT: {
                return new UserRegistrationAcknowledge(message, offset);
            }
            case REGISTRATION_ACKNOWLEDGEMENT: {
                return new RegistrationAcknowledgement(message, offset);
            }
        }
        return new UnknownARSHeader(message, offset);
    }
}

