/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.hytera.sds;

public enum HyteraTokenType {
    RADIO_REGISTRATION_SERVICE_HEADER(512, 1),
    TEXT_MESSAGE_SERVICE_HEADER(513, 4),
    ID_MESSAGE(1, -1),
    ID_SOURCE(2, -1),
    ID_DESTINATION(3, -1),
    ENCODING(257, -1),
    PAYLOAD(258, -1),
    RRS_UNKNOWN(1795, 0),
    UNKNOWN(-1, -1);

    private int mOpcode;
    private int mFieldLength;

    private HyteraTokenType(int opcode, int fieldLength) {
        this.mOpcode = opcode;
        this.mFieldLength = fieldLength;
    }

    public int getOpcode() {
        return this.mOpcode;
    }

    public int getFieldLength() {
        return this.mFieldLength;
    }

    public boolean isFixedLength() {
        return this.mFieldLength >= 0;
    }

    public static HyteraTokenType fromOpcode(int opcode) {
        for (HyteraTokenType token : HyteraTokenType.values()) {
            if (token.getOpcode() != opcode) continue;
            return token;
        }
        return UNKNOWN;
    }
}

