/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.hytera.sds;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.hytera.sds.DestinationId;
import io.github.dsheirer.module.decode.ip.hytera.sds.Encoding;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraToken;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraTokenType;
import io.github.dsheirer.module.decode.ip.hytera.sds.MessageId;
import io.github.dsheirer.module.decode.ip.hytera.sds.Payload;
import io.github.dsheirer.module.decode.ip.hytera.sds.RrsMessageHeader;
import io.github.dsheirer.module.decode.ip.hytera.sds.RrsUnknown;
import io.github.dsheirer.module.decode.ip.hytera.sds.SourceId;
import io.github.dsheirer.module.decode.ip.hytera.sds.TmsMessageHeader;
import io.github.dsheirer.module.decode.ip.hytera.sds.Unknown;

public class HyteraTokenFactory {
    public static HyteraToken getField(HyteraTokenType token, CorrectedBinaryMessage message) {
        return switch (token) {
            case HyteraTokenType.ID_DESTINATION -> new DestinationId(message);
            case HyteraTokenType.ID_MESSAGE -> new MessageId(message);
            case HyteraTokenType.ID_SOURCE -> new SourceId(message);
            case HyteraTokenType.ENCODING -> new Encoding(message);
            case HyteraTokenType.PAYLOAD -> new Payload(message);
            case HyteraTokenType.RRS_UNKNOWN -> new RrsUnknown(message);
            case HyteraTokenType.TEXT_MESSAGE_SERVICE_HEADER -> new TmsMessageHeader(message);
            case HyteraTokenType.RADIO_REGISTRATION_SERVICE_HEADER -> new RrsMessageHeader(message);
            default -> new Unknown(message);
        };
    }
}

