/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.hytera.rrs;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.dmr.identifier.DMRRadio;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.hytera.sds.DestinationId;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraToken;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraTokenHeader;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraTokenType;
import io.github.dsheirer.module.decode.p25.identifier.ipv4.DMRIpAddress;
import java.util.ArrayList;
import java.util.List;

public class HyteraRrsPacket
implements IPacket {
    private HyteraTokenHeader mHeader;
    private Identifier mDestination;
    private List<Identifier> mIdentifiers;

    public HyteraRrsPacket(HyteraTokenHeader header) {
        this.mHeader = header;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HYTERA RRS REGISTER");
        if (this.hasDestination()) {
            sb.append(" RADIO:").append(this.getDestination());
        }
        return sb.toString();
    }

    @Override
    public HyteraTokenHeader getHeader() {
        return this.mHeader;
    }

    public Identifier getDestination() {
        HyteraToken destinationToken;
        if (this.mDestination == null && (destinationToken = this.getHeader().getTokenByType(HyteraTokenType.ID_DESTINATION)) instanceof DestinationId) {
            DestinationId destinationId = (DestinationId)destinationToken;
            this.mDestination = ((DestinationId)destinationToken).isIp() ? DMRIpAddress.createFrom(((DestinationId)destinationToken).getId()) : DMRRadio.createTo(destinationId.getId());
        }
        return this.mDestination;
    }

    public boolean hasDestination() {
        return this.getDestination() != null;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.hasDestination()) {
                this.mIdentifiers.add(this.getDestination());
            }
        }
        return this.mIdentifiers;
    }

    @Override
    public IPacket getPayload() {
        return null;
    }

    @Override
    public boolean hasPayload() {
        return false;
    }
}

