/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ip.IPacket;
import io.github.dsheirer.module.decode.ip.Packet;
import io.github.dsheirer.module.decode.ip.cellocator.CellocatorRadioIdentifier;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPHeader;
import java.util.Collections;
import java.util.List;

public abstract class MCGPPacket
extends Packet {
    private MCGPHeader mHeader;

    public MCGPPacket(MCGPHeader header, CorrectedBinaryMessage message, int offset) {
        super(message, offset);
        this.mHeader = header;
    }

    @Override
    public MCGPHeader getHeader() {
        return this.mHeader;
    }

    protected abstract CellocatorRadioIdentifier getRadioId();

    @Override
    public IPacket getPayload() {
        return null;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        CellocatorRadioIdentifier radioIdentifier = this.getRadioId();
        if (radioIdentifier != null) {
            return Collections.singletonList(radioIdentifier);
        }
        return Collections.emptyList();
    }
}

