/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

import java.util.EnumSet;

public enum MCGPMessageType {
    INBOUND_GENERIC_COMMAND(0, 200, "COMMAND"),
    INBOUND_PROGRAMMING_COMMAND(1, 272, "PROGRAMMING COMMAND"),
    INBOUND_GENERAL_ACKNOWLEDGE(4, 224, "ACKNOWLEDGE"),
    INBOUND_FORWARD_DATA_COMMAND(5, -1, "FORWARD DATA COMMAND"),
    INBOUND_MODULAR_REQUEST(9, -1, "MODULAR MESSAGE REQUEST"),
    OUTBOUND_LOCATION_STATUS(0, 560, "LOCATION AND STATUS"),
    OUTBOUND_PROGRAMMING_STATUS(3, 248, "CONFIGURATION"),
    OUTBOUND_FORWARDED_LOGGED_DATA_FRAGMENT(7, -1, "FORWARDED LOGGED DATA"),
    OUTBOUND_FORWARDED_REALTIME_DATA(8, -1, "FORWARDED SERIAL_PORT DATA"),
    OUTBOUND_MODULAR_RESPONSE(9, -1, "MODULAR MESSAGE RESPONSE"),
    OUTBOUND_FIRMWARE_UPDATE(10, -1, "FIRMWARE UPDATE"),
    UNKNOWN(-1, -1, "UNKNOWN");

    private int mValue;
    private int mLength;
    private String mLabel;
    public static EnumSet<MCGPMessageType> INBOUND;
    public static EnumSet<MCGPMessageType> OUTBOUND;

    private MCGPMessageType(int value, int length, String label) {
        this.mValue = value;
        this.mLength = length;
        this.mLabel = label;
    }

    public int getValue() {
        return this.mValue;
    }

    public int getLength() {
        return this.mLength;
    }

    public static MCGPMessageType fromValue(int value, int messageByteLength) {
        switch (value) {
            case 0: {
                if (messageByteLength == 25) {
                    return INBOUND_GENERIC_COMMAND;
                }
                if (messageByteLength != 70) break;
                return OUTBOUND_LOCATION_STATUS;
            }
            case 1: {
                return INBOUND_PROGRAMMING_COMMAND;
            }
            case 3: {
                return OUTBOUND_PROGRAMMING_STATUS;
            }
            case 4: {
                return INBOUND_GENERAL_ACKNOWLEDGE;
            }
            case 5: {
                return INBOUND_FORWARD_DATA_COMMAND;
            }
            case 7: {
                return OUTBOUND_FORWARDED_LOGGED_DATA_FRAGMENT;
            }
            case 8: {
                return OUTBOUND_FORWARDED_REALTIME_DATA;
            }
            case 9: {
                return INBOUND_MODULAR_REQUEST;
            }
            case 10: {
                return OUTBOUND_FIRMWARE_UPDATE;
            }
        }
        return UNKNOWN;
    }

    public static MCGPMessageType getOutboundMessageType(int value) {
        for (MCGPMessageType type : OUTBOUND) {
            if (type.getValue() != value) continue;
            return type;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.mLabel;
    }

    static {
        INBOUND = EnumSet.range(INBOUND_GENERIC_COMMAND, INBOUND_MODULAR_REQUEST);
        OUTBOUND = EnumSet.range(OUTBOUND_LOCATION_STATUS, OUTBOUND_FIRMWARE_UPDATE);
    }
}

