/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.cellocator.AcknowledgeMessage;
import io.github.dsheirer.module.decode.ip.cellocator.ForwardedDataMessage;
import io.github.dsheirer.module.decode.ip.cellocator.GenericCommandMessage;
import io.github.dsheirer.module.decode.ip.cellocator.LocationStatusMessage;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPHeader;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPMessageType;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPPacket;
import io.github.dsheirer.module.decode.ip.cellocator.ModularRequestMessage;
import io.github.dsheirer.module.decode.ip.cellocator.ModularResponseMessage;
import io.github.dsheirer.module.decode.ip.cellocator.ProgrammingCommandMessage;
import io.github.dsheirer.module.decode.ip.cellocator.ProgrammingStatusMessage;
import io.github.dsheirer.module.decode.ip.cellocator.UnknownMCGPMessage;

public class MCGPMessageFactory {
    public static MCGPPacket create(CorrectedBinaryMessage message, int offset) {
        MCGPHeader header = new MCGPHeader(message, offset);
        int payloadOffset = offset + 40;
        switch (header.getMessageType()) {
            case INBOUND_GENERIC_COMMAND: {
                return new GenericCommandMessage(header, message, payloadOffset);
            }
            case INBOUND_GENERAL_ACKNOWLEDGE: {
                return new AcknowledgeMessage(header, message, payloadOffset);
            }
            case INBOUND_PROGRAMMING_COMMAND: {
                return new ProgrammingCommandMessage(header, message, payloadOffset);
            }
            case OUTBOUND_LOCATION_STATUS: {
                return new LocationStatusMessage(header, message, payloadOffset);
            }
            case OUTBOUND_PROGRAMMING_STATUS: {
                return new ProgrammingStatusMessage(header, message, payloadOffset);
            }
            case OUTBOUND_FORWARDED_REALTIME_DATA: 
            case OUTBOUND_FORWARDED_LOGGED_DATA_FRAGMENT: {
                return new ForwardedDataMessage(header, message, payloadOffset);
            }
            case INBOUND_MODULAR_REQUEST: 
            case OUTBOUND_MODULAR_RESPONSE: {
                if (ModularResponseMessage.getTotalMessageLength(message, payloadOffset) > 0) {
                    header.setMessageType(MCGPMessageType.OUTBOUND_MODULAR_RESPONSE);
                    return new ModularResponseMessage(header, message, payloadOffset);
                }
                return new ModularRequestMessage(header, message, payloadOffset);
            }
        }
        return new UnknownMCGPMessage(header, message, offset);
    }
}

