/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.module.decode.ip.Header;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPMessageType;

public class MCGPHeader
extends Header {
    private static final int[] M_CHARACTER = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] C_CHARACTER = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] G_CHARACTER = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] P_CHARACTER = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int M_VALUE = 77;
    private static final int C_VALUE = 67;
    private static final int G_VALUE = 71;
    private static final int P_VALUE = 80;
    private static final int[] MESSAGE_TYPE = new int[]{32, 33, 34, 35, 36, 37, 38, 39};
    public static final int HEADER_LENGTH = 40;
    private MCGPMessageType mMessageType;

    public MCGPHeader(BinaryMessage message, int offset) {
        super(message, offset);
    }

    public static boolean isCellocatorMessage(BinaryMessage message, int offset) {
        return message.getInt(M_CHARACTER, offset) == 77 && message.getInt(C_CHARACTER, offset) == 67 && message.getInt(G_CHARACTER, offset) == 71 && message.getInt(P_CHARACTER, offset) == 80;
    }

    @Override
    public int getLength() {
        return 40;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CELLOCATOR ").append((Object)this.getMessageType());
        if (this.getMessageType() == MCGPMessageType.UNKNOWN) {
            sb.append(" PACKET:").append(this.getMessage().toHexString());
        }
        return sb.toString();
    }

    public MCGPMessageType getMessageType() {
        if (this.mMessageType == null) {
            this.mMessageType = MCGPHeader.getMessageType(this.getMessage(), this.getOffset());
        }
        return this.mMessageType;
    }

    void setMessageType(MCGPMessageType type) {
        this.mMessageType = type;
    }

    public static MCGPMessageType getMessageType(BinaryMessage message, int offset) {
        int payloadLengthBytes = (message.size() - offset) / 8;
        return MCGPMessageType.fromValue(message.getInt(MESSAGE_TYPE, offset), payloadLengthBytes);
    }

    public int getMessageTypeValue() {
        return this.getMessage().getInt(MESSAGE_TYPE, this.getOffset());
    }
}

