/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.cellocator.CellocatorRadioIdentifier;
import io.github.dsheirer.module.decode.ip.cellocator.FragmentControl;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPHeader;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPMessageType;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPPacket;

public class ForwardedDataMessage
extends MCGPPacket {
    private static final int[] TARGET_UNIT_ID = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 16, 17, 18, 19, 20, 21, 22, 23, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] COMMAND_NUMERATOR = new int[]{48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] FORWARDED_MESSAGE_NUMBER = new int[]{88, 89, 90, 91, 92, 93, 94, 95};
    private static final int[] FRAGMENT_CONTROL = new int[]{96, 97, 98, 99, 100, 101, 102, 103};
    private static final int[] PAYLOAD_LENGTH = new int[]{112, 113, 114, 115, 116, 117, 118, 119, 104, 105, 106, 107, 108, 109, 110, 111};
    private static final int PAYLOAD_START = 120;
    private CellocatorRadioIdentifier mTargetRadioId;
    private FragmentControl mFragmentControl;

    public ForwardedDataMessage(MCGPHeader header, CorrectedBinaryMessage message, int offset) {
        super(header, message, offset);
    }

    @Override
    public CellocatorRadioIdentifier getRadioId() {
        if (this.mTargetRadioId == null) {
            this.mTargetRadioId = CellocatorRadioIdentifier.createTo(this.getMessage().getInt(TARGET_UNIT_ID, this.getOffset()));
        }
        return this.mTargetRadioId;
    }

    public FragmentControl getFragmentControl() {
        if (this.mFragmentControl == null) {
            this.mFragmentControl = new FragmentControl(this.getMessage().getInt(FRAGMENT_CONTROL, this.getOffset()));
        }
        return this.mFragmentControl;
    }

    public int getMessageNumerator() {
        return this.getMessage().getInt(COMMAND_NUMERATOR, this.getOffset());
    }

    public int getForwardedMessageNumerator() {
        return this.getMessage().getInt(FORWARDED_MESSAGE_NUMBER, this.getOffset());
    }

    private int getPayloadLength() {
        return this.getMessage().getInt(PAYLOAD_LENGTH, this.getOffset());
    }

    public String getPayloadData() {
        int payloadEnd = 120 + this.getPayloadLength() * 8;
        return this.getMessage().get(120, payloadEnd).toHexString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CELLOCATOR TO RADIO:");
        sb.append(this.getRadioId());
        sb.append(" MESSAGE NUMBER:").append(this.getMessageNumerator());
        if (this.getHeader().getMessageType() == MCGPMessageType.OUTBOUND_FORWARDED_REALTIME_DATA) {
            sb.append(" FORWARDED SERIAL PORT DATA");
        } else {
            sb.append(" FORWARDED LOGGED DATA");
        }
        sb.append(" MESSAGE NUMBER:").append(this.getForwardedMessageNumerator());
        sb.append(" ").append(this.getFragmentControl());
        return sb.toString();
    }
}

