/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

public class CommunicationControl {
    private static final int MASK_CAN_ORIGINATED_ODOMETER = 32768;
    private static final int MASK_CAN_ORIGINATED_SPEED = 16384;
    private static final int MASK_MULTI_PURPOSE_FIELD_CONTENT = 12288;
    private static final int MASK_CR200_CR300_MESSAGE_SOURCE = 2048;
    private static final int MASK_GARMIN_CONNECTED = 1024;
    private static final int MASK_GARMIN_ENABLED = 512;
    private static final int MASK_CR200_CR300_MESSAGE_INITIATIVE = 256;
    private static final int MASK_CR200_CR300_GSM_HIBERNATION_INDICATOR = 128;
    private static final int MASK_MOMENTARY_OR_MAX_SPEED_VALUE = 64;
    private static final int MASK_BUSINESS_OR_PRIVATE_MODE = 32;
    private static final int MASK_FIRMWARE_SUB_VERSION = 31;
    private int mValue;

    public CommunicationControl(int value) {
        this.mValue = value;
    }

    public boolean isCANOriginatedOdometer() {
        return this.isSet(32768);
    }

    public boolean isCANOriginatedSpeed() {
        return this.isSet(16384);
    }

    public boolean isGarminConnected() {
        return this.isSet(1024);
    }

    public boolean isGarminEnabled() {
        return this.isSet(512);
    }

    public Initiative getMessageSource() {
        return this.isSet(256) ? Initiative.RESPONSE : Initiative.ACTIVE;
    }

    public SpeedType getSpeedType() {
        return this.isSet(64) ? SpeedType.MAX : SpeedType.MOMENTARY;
    }

    private boolean isSet(int mask) {
        return (this.mValue & mask) == mask;
    }

    public static enum Initiative {
        ACTIVE,
        RESPONSE;

    }

    public static enum SpeedType {
        MOMENTARY,
        MAX;

    }
}

