/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ip.cellocator;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.ip.cellocator.CellocatorRadioIdentifier;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPHeader;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPMessageType;
import io.github.dsheirer.module.decode.ip.cellocator.MCGPPacket;
import java.util.Date;
import java.util.GregorianCalendar;

public class AcknowledgeMessage
extends MCGPPacket {
    private static final int[] TARGET_UNIT_ID = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 16, 17, 18, 19, 20, 21, 22, 23, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] COMMAND_NUMERATOR = new int[]{32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] AUTHENTICATION_CODE = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 56, 57, 58, 59, 60, 61, 62, 63, 48, 49, 50, 51, 52, 53, 54, 55, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] ACTION_CODE = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] MAIN_ACKNOWLEDGE_NUMBER = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] SECONDARY_ACKNOWLEDGE_NUMBER = new int[]{104, 105, 106, 107, 108, 109, 110, 111, 96, 97, 98, 99, 100, 101, 102, 103};
    private static final int[] RESERVED = new int[]{112, 113, 114, 115, 116, 117, 118, 119};
    private static final int[] YEAR = new int[]{121, 122, 123, 124, 125, 126, 127};
    private static final int[] MONTH = new int[]{133, 134, 135, 120};
    private static final int[] DAY = new int[]{128, 129, 130, 131, 132};
    private static final int[] RESERVED_2 = new int[]{152, 153, 154, 155, 156, 157, 158};
    private static final int[] HOUR = new int[]{139, 140, 141, 142, 143};
    private static final int[] MINUTE = new int[]{149, 150, 151, 136, 137, 138};
    private static final int[] SECOND = new int[]{159, 144, 145, 146, 147, 148};
    private CellocatorRadioIdentifier mTargetRadioId;

    public AcknowledgeMessage(MCGPHeader header, CorrectedBinaryMessage message, int offset) {
        super(header, message, offset);
    }

    @Override
    public CellocatorRadioIdentifier getRadioId() {
        if (this.mTargetRadioId == null) {
            this.mTargetRadioId = CellocatorRadioIdentifier.createTo(this.getMessage().getInt(TARGET_UNIT_ID, this.getOffset()));
        }
        return this.mTargetRadioId;
    }

    public MCGPMessageType getAcknowledgedCommand() {
        int command = this.getMessage().getInt(COMMAND_NUMERATOR, this.getOffset());
        return MCGPMessageType.getOutboundMessageType(command);
    }

    public String getAuthenticationCode() {
        return Integer.toHexString(this.getMessage().getInt(AUTHENTICATION_CODE, this.getOffset())).toUpperCase();
    }

    public int getActionCode() {
        return this.getMessage().getInt(ACTION_CODE, this.getOffset());
    }

    public int getMainAcknowledgeNumber() {
        return this.getMessage().getInt(MAIN_ACKNOWLEDGE_NUMBER, this.getOffset());
    }

    public int getSecondaryAcknowledgeNumber() {
        return this.getMessage().getInt(SECONDARY_ACKNOWLEDGE_NUMBER, this.getOffset());
    }

    public long getTimestamp() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.clear();
        int year = 2000 + this.getMessage().getInt(YEAR, this.getOffset());
        int month = this.getMessage().getInt(MONTH, this.getOffset()) - 1;
        int day = this.getMessage().getInt(DAY, this.getOffset());
        int hour = this.getMessage().getInt(HOUR, this.getOffset());
        int minute = this.getMessage().getInt(MINUTE, this.getOffset());
        int second = this.getMessage().getInt(SECOND, this.getOffset());
        calendar.set(year, month, day, hour, minute, second);
        return calendar.getTimeInMillis();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CELLOCATOR RADIO:");
        sb.append(this.getRadioId());
        sb.append(" ACKNOWLEDGE:").append((Object)this.getAcknowledgedCommand());
        sb.append(" MESSAGE NUMBER:").append(this.getMainAcknowledgeNumber());
        sb.append(" TIME:").append(new Date(this.getTimestamp()));
        sb.append(" AUTH:").append(this.getAuthenticationCode());
        return sb.toString();
    }
}

