/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.fleetsync2.message;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.edac.CRCFleetsync;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.module.decode.fleetsync2.FleetsyncMessageType;
import io.github.dsheirer.module.decode.fleetsync2.identifier.FleetsyncIdentifier;
import io.github.dsheirer.protocol.Protocol;

public abstract class Fleetsync2Message
extends Message {
    private static int[] BIT_REVERSALS = new int[]{0, 1, 2, 3, 4};
    private static int[] SYNC_PATTERN = new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    private static int[] STATUS = new int[]{21, 22, 23, 24, 25, 26, 27};
    private static int[] MESSAGE_TYPE = new int[]{29, 30, 31, 32, 33};
    private static int FLAG_UNKNOWN_1 = 21;
    private static int FLAG_EMERGENCY_WORKER = 22;
    private static int FLAG_UNKNOWN_2 = 23;
    private static int FLAG_LONE_WORKER = 24;
    private static int FLAG_UNKNOWN_3 = 25;
    private static int FLAG_PAGING = 26;
    private static int FLAG_END_OF_TRANSMISSION = 27;
    private static int FLAG_MANUAL = 28;
    private static int FLAG_AUTOMATIC_NUMBER_IDENTIFIER = 29;
    private static int FLAG_STATUS = 30;
    private static int FLAG_ACKNOWLEDGE = 31;
    private static int FLAG_UNKNOWN_4 = 32;
    private static int FLAG_UNKNOWN_5 = 33;
    private static int FLAG_UNKNOWN_6 = 34;
    private static int FLAG_GPS_EXTENSION = 35;
    private static int FLAG_FLEET_EXTENSION = 36;
    private static int[] FLEET = new int[]{37, 38, 39, 40, 41, 42, 43, 44};
    private static int[] FROM_IDENT = new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56};
    private static int[] TO_IDENT = new int[]{57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68};
    private static int[] CRC_BLOCK_1 = new int[]{69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84};
    private static int[] FLEET_TO = new int[]{85, 86, 87, 88, 89, 90, 91, 92};
    private static int[] CRC_BLOCK_2 = new int[]{132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148};
    private CorrectedBinaryMessage mMessage;
    private CRC[] mCRC = new CRC[2];
    private FleetsyncIdentifier mFromIdentifier;
    private FleetsyncIdentifier mToIdentifier;

    public Fleetsync2Message(CorrectedBinaryMessage message, long timestamp) {
        super(timestamp);
        this.mMessage = message;
        this.checkParity();
    }

    protected CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.FLEETSYNC;
    }

    protected abstract int getBlockCount();

    public FleetsyncIdentifier getFromIdentifier() {
        if (this.mFromIdentifier == null) {
            this.mFromIdentifier = FleetsyncIdentifier.createFromUser(this.getCommonFleet() + this.getFromIdent());
        }
        return this.mFromIdentifier;
    }

    public FleetsyncIdentifier getToIdentifier() {
        if (this.mToIdentifier == null) {
            int value = (Fleetsync2Message.hasFleetExtensionFlag(this.getMessage()) ? this.getExtendedFleet() : this.getCommonFleet()) + this.getToIdent();
            this.mToIdentifier = FleetsyncIdentifier.createToUser(value);
        }
        return this.mToIdentifier;
    }

    private int getCommonFleet() {
        return this.getMessage().getInt(FLEET) + 99 << 12;
    }

    private int getExtendedFleet() {
        return this.getMessage().getInt(FLEET_TO) + 99 << 12;
    }

    private int getFromIdent() {
        return this.getMessage().getInt(FROM_IDENT) + 999;
    }

    private int getToIdent() {
        return this.getMessage().getInt(TO_IDENT) + 999;
    }

    private void checkParity() {
        CRC block1Crc = Fleetsync2Message.detectAndCorrect(this.getMessage(), 21, 85);
        this.mCRC = new CRC[this.getBlockCount()];
        this.mCRC[0] = block1Crc;
        for (int x = 1; x < this.getBlockCount(); ++x) {
            int blockStart = 21 + x * 64;
            this.mCRC[x] = Fleetsync2Message.detectAndCorrect(this.getMessage(), blockStart, blockStart + 64);
        }
    }

    public static CRC detectAndCorrect(CorrectedBinaryMessage message, int start, int end) {
        int[] errorBitPositions;
        BinaryMessage original = message.get(start, end);
        CRC retVal = CRCFleetsync.check(original);
        if (retVal == CRC.FAILED_PARITY && (errorBitPositions = CRCFleetsync.findBitErrors(original)) != null) {
            for (int errorBitPosition : errorBitPositions) {
                message.flip(start + errorBitPosition);
                message.incrementCorrectedBitCount(1);
            }
            retVal = CRC.CORRECTED;
        }
        return retVal;
    }

    @Override
    public boolean isValid() {
        return this.mCRC[0].passes();
    }

    public FleetsyncMessageType getMessageType() {
        return Fleetsync2Message.getMessageType(this.getMessage());
    }

    public static FleetsyncMessageType getMessageType(BinaryMessage message) {
        if (Fleetsync2Message.hasAcknowledgeFlag(message)) {
            return FleetsyncMessageType.ACKNOWLEDGE;
        }
        if (Fleetsync2Message.hasGPSFlag(message)) {
            return FleetsyncMessageType.GPS;
        }
        if (Fleetsync2Message.hasStatusFlag(message)) {
            return FleetsyncMessageType.STATUS;
        }
        if (Fleetsync2Message.hasANIFlag(message)) {
            return FleetsyncMessageType.ANI;
        }
        if (Fleetsync2Message.hasPagingFlag(message)) {
            return FleetsyncMessageType.PAGING;
        }
        if (Fleetsync2Message.hasLoneWorkerFlag(message) && Fleetsync2Message.hasEmergencyFlag(message)) {
            return FleetsyncMessageType.LONE_WORKER_EMERGENCY;
        }
        return FleetsyncMessageType.UNKNOWN;
    }

    public static boolean hasEndOfTransmissionFlag(BinaryMessage message) {
        return !message.get(FLAG_END_OF_TRANSMISSION);
    }

    public static boolean hasEmergencyFlag(BinaryMessage message) {
        return !message.get(FLAG_EMERGENCY_WORKER);
    }

    public static boolean hasLoneWorkerFlag(BinaryMessage message) {
        return !message.get(FLAG_LONE_WORKER);
    }

    public static boolean hasPagingFlag(BinaryMessage message) {
        return !message.get(FLAG_PAGING);
    }

    public static boolean hasANIFlag(BinaryMessage message) {
        return message.get(FLAG_AUTOMATIC_NUMBER_IDENTIFIER);
    }

    public static boolean hasAcknowledgeFlag(BinaryMessage message) {
        return message.get(FLAG_ACKNOWLEDGE);
    }

    public static boolean hasFleetExtensionFlag(BinaryMessage message) {
        return message.get(FLAG_FLEET_EXTENSION);
    }

    public static boolean hasGPSFlag(BinaryMessage message) {
        return message.get(FLAG_GPS_EXTENSION);
    }

    public static boolean hasStatusFlag(BinaryMessage message) {
        return message.get(FLAG_STATUS);
    }
}

