/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.fleetsync2;

import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.event.PlottableDecodeEvent;
import io.github.dsheirer.module.decode.fleetsync2.FleetsyncMessageType;
import io.github.dsheirer.module.decode.fleetsync2.identifier.FleetsyncIdentifier;
import io.github.dsheirer.module.decode.fleetsync2.message.Fleetsync2Message;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Fleetsync2DecoderState
extends DecoderState {
    private Map<FleetsyncIdentifier, Integer> mFromIdentCountsMap = new HashMap<FleetsyncIdentifier, Integer>();
    private Map<FleetsyncIdentifier, Integer> mToIdentCountsMap = new HashMap<FleetsyncIdentifier, Integer>();

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.FLEETSYNC2;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void init() {
    }

    @Override
    public void receive(IMessage message) {
        if (message.isValid() && message instanceof Fleetsync2Message) {
            Fleetsync2Message fleetsync = (Fleetsync2Message)message;
            this.getIdentifierCollection().update(fleetsync.getIdentifiers());
            FleetsyncIdentifier from = fleetsync.getFromIdentifier();
            if (this.mFromIdentCountsMap.containsKey(from)) {
                this.mFromIdentCountsMap.put(from, this.mFromIdentCountsMap.get(from) + 1);
            } else {
                this.mFromIdentCountsMap.put(from, 1);
            }
            FleetsyncIdentifier to = fleetsync.getToIdentifier();
            if (to != null) {
                if (this.mToIdentCountsMap.containsKey(to)) {
                    this.mToIdentCountsMap.put(to, this.mToIdentCountsMap.get(to) + 1);
                } else {
                    this.mToIdentCountsMap.put(to, 1);
                }
            }
            switch (fleetsync.getMessageType()) {
                case ANI: 
                case EMERGENCY: 
                case LONE_WORKER_EMERGENCY: {
                    DecodeEvent aniEvent = this.getDecodeEvent(fleetsync, this.getDecodeEventType(fleetsync.getMessageType()));
                    this.broadcast(aniEvent);
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.CALL));
                    break;
                }
                case ACKNOWLEDGE: 
                case PAGING: 
                case STATUS: 
                case UNKNOWN: {
                    DecodeEvent statusEvent = this.getDecodeEvent(fleetsync, this.getDecodeEventType(fleetsync.getMessageType()));
                    this.broadcast(statusEvent);
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.DATA));
                    break;
                }
                case GPS: {
                    PlottableDecodeEvent plottableDecodeEvent = PlottableDecodeEvent.plottableBuilder(DecodeEventType.GPS, fleetsync.getTimestamp()).channel(this.getCurrentChannel()).details(fleetsync.toString()).identifiers(this.getIdentifierCollection().copyOf()).protocol(Protocol.FLEETSYNC).build();
                    this.broadcast(plottableDecodeEvent);
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.DECODE, State.DATA));
                }
            }
            this.getIdentifierCollection().remove(IdentifierClass.USER);
        }
    }

    private DecodeEvent getDecodeEvent(Fleetsync2Message fleetsync, DecodeEventType eventType) {
        return DecodeEvent.builder(eventType, fleetsync.getTimestamp()).channel(this.getCurrentChannel()).details(String.valueOf((Object)fleetsync.getMessageType()) + " " + String.valueOf(fleetsync)).identifiers(this.getIdentifierCollection().copyOf()).protocol(Protocol.FLEETSYNC).build();
    }

    private DecodeEventType getDecodeEventType(FleetsyncMessageType fleetsyncMessageType) {
        switch (fleetsyncMessageType) {
            case ANI: {
                return DecodeEventType.ID_ANI;
            }
            case EMERGENCY: 
            case LONE_WORKER_EMERGENCY: {
                return DecodeEventType.EMERGENCY;
            }
            case ACKNOWLEDGE: {
                return DecodeEventType.ACKNOWLEDGE;
            }
            case PAGING: {
                return DecodeEventType.PAGE;
            }
            case STATUS: {
                return DecodeEventType.STATUS;
            }
            case GPS: {
                return DecodeEventType.GPS;
            }
        }
        return DecodeEventType.UNKNOWN;
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        switch (event.getEvent()) {
            case REQUEST_RESET: {
                this.reset();
                break;
            }
        }
    }

    @Override
    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("=============================\n");
        sb.append("Decoder:\tFleetsync II\n\n");
        if (this.mFromIdentCountsMap.isEmpty() && this.mToIdentCountsMap.isEmpty()) {
            sb.append("Fleetsync Idents\n");
            sb.append("  None\n");
        } else {
            sb.append("Fleetsync From Idents\n");
            ArrayList<FleetsyncIdentifier> fromIdents = new ArrayList<FleetsyncIdentifier>(this.mFromIdentCountsMap.keySet());
            Collections.sort(fromIdents);
            for (FleetsyncIdentifier from : fromIdents) {
                sb.append("  ").append(from.formatted()).append(" - Count:").append(this.mFromIdentCountsMap.get(from)).append("\n");
            }
            sb.append("\nFleetsync To Idents\n");
            ArrayList<FleetsyncIdentifier> toIdents = new ArrayList<FleetsyncIdentifier>(this.mToIdentCountsMap.keySet());
            Collections.sort(toIdents);
            for (FleetsyncIdentifier to : toIdents) {
                sb.append("  ").append(to.formatted()).append(" - Count:").append(this.mToIdentCountsMap.get(to)).append("\n");
            }
        }
        return sb.toString();
    }
}

