/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.event.filter;

import com.jidesoft.swing.JideSplitButton;
import io.github.dsheirer.module.decode.event.filter.EventClearHandler;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;

public class EventClearButton
extends JideSplitButton {
    private static final long serialVersionUID = 1L;
    private EventClearHandler mEventClearHandler;

    public EventClearButton(int maxHistoryCount) {
        super("Clear");
        JPanel historyPanel = new JPanel();
        historyPanel.add(new JLabel("History Size:"));
        JSlider historySlider = this.initializeHistorySlider();
        JLabel valueLabel = new JLabel(String.valueOf(maxHistoryCount));
        historySlider.setValue(maxHistoryCount);
        historySlider.addChangeListener(arg0 -> {
            if (this.mEventClearHandler != null) {
                this.mEventClearHandler.onHistoryLimitChanged(historySlider.getValue());
            }
            valueLabel.setText(String.valueOf(historySlider.getValue()));
        });
        historyPanel.add(historySlider);
        historyPanel.add(valueLabel);
        this.add(historyPanel);
        this.addActionListener(e -> {
            if (this.mEventClearHandler != null) {
                this.mEventClearHandler.onClearHistoryClicked();
            }
        });
    }

    public void setEventClearHandler(EventClearHandler eventClearHandler) {
        this.mEventClearHandler = eventClearHandler;
    }

    private JSlider initializeHistorySlider() {
        final JSlider slider = new JSlider();
        slider.setMinimum(0);
        slider.setMaximum(2000);
        slider.setMajorTickSpacing(500);
        slider.setPaintTicks(true);
        slider.setPaintLabels(true);
        slider.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (SwingUtilities.isLeftMouseButton(arg0) && arg0.getClickCount() == 2) {
                    slider.setValue(500);
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        return slider;
    }
}

