/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.event;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.protocol.Protocol;
import org.jdesktop.swingx.mapviewer.GeoPosition;

public class PlottableDecodeEvent
extends DecodeEvent {
    private GeoPosition mGeoPosition;
    private double mHeading;
    private double mSpeed;

    public PlottableDecodeEvent(DecodeEventType decodeEventType, long start) {
        super(decodeEventType, start);
    }

    public static PlottableDecodeEventBuilder plottableBuilder(DecodeEventType decodeEventType, long timeStart) {
        return new PlottableDecodeEventBuilder(decodeEventType, timeStart);
    }

    public void setLocation(GeoPosition geoPosition) {
        this.mGeoPosition = geoPosition;
    }

    public GeoPosition getLocation() {
        return this.mGeoPosition;
    }

    public void setHeading(double heading) {
        this.mHeading = heading;
    }

    public double getHeading() {
        return this.mHeading;
    }

    public void setSpeed(double speed) {
        this.mSpeed = speed;
    }

    public double getSpeed() {
        return this.mSpeed;
    }

    public static class PlottableDecodeEventBuilder {
        private long mTimeStart;
        private long mDuration;
        private DecodeEventType mDecodeEventType;
        private IdentifierCollection mIdentifierCollection;
        private IChannelDescriptor mChannelDescriptor;
        private String mDetails;
        private Protocol mProtocol = Protocol.UNKNOWN;
        private GeoPosition mGeoPosition;
        private double mHeading;
        private double mSpeed;

        public PlottableDecodeEventBuilder(DecodeEventType decodeEventType, long timeStart) {
            this.mDecodeEventType = decodeEventType;
            this.mTimeStart = timeStart;
        }

        public PlottableDecodeEventBuilder duration(long duration) {
            this.mDuration = duration;
            return this;
        }

        public PlottableDecodeEventBuilder end(long timestamp) {
            this.mDuration = timestamp - this.mTimeStart;
            return this;
        }

        public PlottableDecodeEventBuilder channel(IChannelDescriptor channelDescriptor) {
            this.mChannelDescriptor = channelDescriptor;
            return this;
        }

        public PlottableDecodeEventBuilder identifiers(IdentifierCollection identifierCollection) {
            this.mIdentifierCollection = identifierCollection;
            return this;
        }

        public PlottableDecodeEventBuilder details(String details) {
            this.mDetails = details;
            return this;
        }

        public PlottableDecodeEventBuilder protocol(Protocol protocol) {
            this.mProtocol = protocol;
            return this;
        }

        public PlottableDecodeEventBuilder location(GeoPosition geoPosition) {
            this.mGeoPosition = geoPosition;
            return this;
        }

        public PlottableDecodeEventBuilder speed(double speed) {
            this.mSpeed = speed;
            return this;
        }

        public PlottableDecodeEventBuilder heading(double heading) {
            this.mHeading = heading;
            return this;
        }

        public PlottableDecodeEvent build() {
            PlottableDecodeEvent decodeEvent = new PlottableDecodeEvent(this.mDecodeEventType, this.mTimeStart);
            decodeEvent.setChannelDescriptor(this.mChannelDescriptor);
            decodeEvent.setDetails(this.mDetails);
            decodeEvent.setDuration(this.mDuration);
            decodeEvent.setIdentifierCollection(this.mIdentifierCollection);
            decodeEvent.setProtocol(this.mProtocol);
            decodeEvent.setLocation(this.mGeoPosition);
            decodeEvent.setHeading(this.mHeading);
            decodeEvent.setSpeed(this.mSpeed);
            return decodeEvent;
        }
    }
}

