/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.event;

import io.github.dsheirer.filter.FilterSet;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.MessageHistory;
import io.github.dsheirer.module.ProcessingChain;
import io.github.dsheirer.module.decode.DecoderFactory;
import io.github.dsheirer.module.decode.event.HistoryManagementPanel;
import io.github.dsheirer.module.decode.event.MessageActivityModel;
import io.github.dsheirer.module.decode.event.MessageItem;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.swing.JTableColumnWidthMonitor;
import io.github.dsheirer.sample.Listener;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageActivityPanel
extends JPanel
implements Listener<ProcessingChain> {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(MessageActivityPanel.class);
    private final String TABLE_PREFERENCE_KEY = "message.activity.panel";
    private MessageActivityModel mMessageModel = new MessageActivityModel();
    private MessageHistory mCurrentMessageHistory;
    private JTable mTable = new JTable(this.mMessageModel);
    private TableRowSorter<TableModel> mTableRowSorter;
    private JTableColumnWidthMonitor mTableColumnWidthMonitor;
    private UserPreferences mUserPreferences;
    private FilterSet<IMessage> mMessageFilterSet;
    private HistoryManagementPanel<IMessage> mHistoryManagementPanel;

    public MessageActivityPanel(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        this.mTableRowSorter = new TableRowSorter<MessageActivityModel>(this.mMessageModel);
        this.mTableRowSorter.setRowFilter(new MessageRowFilter());
        this.mTable.setRowSorter(this.mTableRowSorter);
        this.mTableColumnWidthMonitor = new JTableColumnWidthMonitor(this.mUserPreferences, this.mTable, "message.activity.panel");
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[][grow,fill]", "[]0[grow,fill]"));
        this.mHistoryManagementPanel = new HistoryManagementPanel(this.mMessageModel, "Message Filter Editor");
        this.add(this.mHistoryManagementPanel, "span,growx");
        this.add((Component)new JScrollPane(this.mTable), "span,grow");
    }

    @Override
    public void receive(ProcessingChain processingChain) {
        if (this.mCurrentMessageHistory != null) {
            this.mCurrentMessageHistory.removeListener(this.mMessageModel);
        }
        if (this.mMessageFilterSet != null) {
            this.mMessageFilterSet.register(null);
        }
        if (processingChain != null) {
            this.mCurrentMessageHistory = processingChain.getMessageHistory();
            this.mMessageFilterSet = DecoderFactory.getMessageFilters(processingChain.getModules());
            this.mMessageFilterSet.register(() -> this.mMessageModel.fireTableDataChanged());
            if (this.mHistoryManagementPanel != null) {
                this.mHistoryManagementPanel.updateFilterSet(this.mMessageFilterSet);
            }
            ArrayList<MessageItem> currentHistory = new ArrayList<MessageItem>();
            for (IMessage message : this.mCurrentMessageHistory.getItems()) {
                currentHistory.add(new MessageItem(message));
            }
            this.mMessageModel.clearAndSet(currentHistory);
            this.mCurrentMessageHistory.addListener(this.mMessageModel);
            this.mHistoryManagementPanel.setEnabled(true);
        } else {
            this.mCurrentMessageHistory = null;
            this.mMessageFilterSet = null;
            this.mMessageModel.clear();
            this.mHistoryManagementPanel.setEnabled(false);
        }
    }

    public class MessageRowFilter
    extends RowFilter<TableModel, Integer> {
        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            TableModel tableModel = entry.getModel();
            if (tableModel instanceof MessageActivityModel) {
                MessageActivityModel model = (MessageActivityModel)tableModel;
                MessageItem item = (MessageItem)model.getItem(entry.getIdentifier());
                if (MessageActivityPanel.this.mMessageFilterSet != null && item != null && item.getMessage() != null) {
                    IMessage message = item.getMessage();
                    return MessageActivityPanel.this.mMessageFilterSet.canProcess(message) && MessageActivityPanel.this.mMessageFilterSet.passes(message);
                }
            }
            return false;
        }
    }
}

