/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.event;

import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.StuffBitsMessage;
import io.github.dsheirer.module.decode.event.ClearableHistoryModel;
import io.github.dsheirer.module.decode.event.MessageItem;
import io.github.dsheirer.sample.Listener;
import java.awt.EventQueue;
import java.text.SimpleDateFormat;

public class MessageActivityModel
extends ClearableHistoryModel<MessageItem>
implements Listener<IMessage> {
    private static final long serialVersionUID = 1L;
    private static final int TIME = 0;
    private static final int PROTOCOL = 1;
    private static final int TIMESLOT = 2;
    private static final int MESSAGE = 3;
    private String[] mHeaders = new String[]{"Time", "Protocol", "Timeslot", "Message"};
    private SimpleDateFormat mSDFTime = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");

    @Override
    public void receive(IMessage message) {
        if (message instanceof StuffBitsMessage) {
            return;
        }
        EventQueue.invokeLater(() -> this.add(new MessageItem(message)));
    }

    @Override
    public int getColumnCount() {
        return this.mHeaders.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.mHeaders[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MessageItem item = (MessageItem)this.getItem(rowIndex);
        if (item != null) {
            switch (columnIndex) {
                case 0: {
                    return item.getTimestamp(this.mSDFTime);
                }
                case 1: {
                    return item.getProtocol();
                }
                case 2: {
                    return item.getTimeslot();
                }
                case 3: {
                    return item.getText();
                }
            }
        }
        return null;
    }
}

