/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.event;

import java.util.Arrays;
import java.util.EnumSet;

public enum DecodeEventType {
    AFFILIATE("Affiliate"),
    ANNOUNCEMENT("Announcement"),
    ACKNOWLEDGE("Acknowledge"),
    AUTOMATIC_REGISTRATION_SERVICE("Motorola ARS"),
    CALL("Call"),
    CALL_ENCRYPTED("Encrypted Call"),
    CALL_GROUP("Group Call"),
    CALL_GROUP_ENCRYPTED("Encrypted Group Call"),
    CALL_PATCH_GROUP("Patch Call"),
    CALL_PATCH_GROUP_ENCRYPTED("Encrypted Patch Call"),
    CALL_ALERT("Call Alert"),
    CALL_DETECT("Call Detect"),
    CALL_IN_PROGRESS("Call In Progress"),
    CALL_DO_NOT_MONITOR("Call-Do Not Monitor"),
    CALL_END("Call End"),
    CALL_INTERCONNECT("Telephone Call"),
    CALL_INTERCONNECT_ENCRYPTED("Encrypted Telephone Call"),
    CALL_UNIQUE_ID("UID Call"),
    CALL_UNIT_TO_UNIT("Unit To Unit Call"),
    CALL_UNIT_TO_UNIT_ENCRYPTED("Encrypted Unit To Unit Call"),
    CALL_NO_TUNER("Call - No Tuner"),
    CALL_TIMEOUT("Call Timeout"),
    CELLOCATOR("Cellocator"),
    COMMAND("Command"),
    DATA_CALL("Data Call"),
    DATA_CALL_ENCRYPTED("Encrypted Data Call"),
    DATA_PACKET("Data Packet"),
    DEREGISTER("Deregister"),
    EMERGENCY("EMERGENCY"),
    FUNCTION("Function"),
    GPS("GPS"),
    ICMP_PACKET("ICMP Packet"),
    ID_ANI("ANI"),
    ID_UNIQUE("Unique ID"),
    IP_PACKET("IP Packet"),
    LRRP("Motorola LRRP"),
    NOTIFICATION("Notification"),
    PAGE("Page"),
    QUERY("Query"),
    RADIO_CHECK("Radio Check"),
    RADIO_REGISTRATION_SERVICE("Hytera RRS"),
    REGISTER("Register"),
    REGISTER_ESN("ESN"),
    REQUEST("Request"),
    RESPONSE("Response"),
    RESPONSE_PACKET("Response Packet"),
    SDM("Short Data Message"),
    SMS("SMS"),
    STATION_ID("Station ID"),
    STATUS("Status"),
    UDP_PACKET("UDP/IP Packet"),
    UNKNOWN_PACKET("Unknown Packet"),
    XCMP("Motorola XCMP"),
    UNKNOWN("Unknown");

    private final String mLabel;
    public static final EnumSet<DecodeEventType> VOICE_CALLS_ENCRYPTED;
    public static final EnumSet<DecodeEventType> VOICE_CALLS;
    public static final EnumSet<DecodeEventType> COMMANDS;
    public static final EnumSet<DecodeEventType> DATA_CALLS;
    public static final EnumSet<DecodeEventType> REGISTRATION;
    public static final EnumSet<DecodeEventType> OTHERS;

    private DecodeEventType(String label) {
        this.mLabel = label;
    }

    public boolean isGrouped() {
        return VOICE_CALLS.contains((Object)this) || VOICE_CALLS_ENCRYPTED.contains((Object)this) || COMMANDS.contains((Object)this) || DATA_CALLS.contains((Object)this) || REGISTRATION.contains((Object)this);
    }

    public String getLabel() {
        return this.mLabel;
    }

    public String toString() {
        return this.mLabel;
    }

    static {
        VOICE_CALLS_ENCRYPTED = EnumSet.of(CALL_ENCRYPTED, CALL_GROUP_ENCRYPTED, CALL_PATCH_GROUP_ENCRYPTED, CALL_INTERCONNECT_ENCRYPTED, CALL_UNIT_TO_UNIT_ENCRYPTED);
        VOICE_CALLS = EnumSet.of(CALL_GROUP, new DecodeEventType[]{CALL_PATCH_GROUP, CALL_ALERT, CALL_DETECT, CALL_DO_NOT_MONITOR, CALL_END, CALL_INTERCONNECT, CALL_UNIQUE_ID, CALL_UNIT_TO_UNIT, CALL_NO_TUNER, CALL_TIMEOUT});
        COMMANDS = EnumSet.of(ANNOUNCEMENT, new DecodeEventType[]{STATION_ID, ACKNOWLEDGE, PAGE, QUERY, RADIO_CHECK, STATUS, COMMAND, EMERGENCY, NOTIFICATION, FUNCTION});
        DATA_CALLS = EnumSet.of(DATA_CALL, new DecodeEventType[]{DATA_CALL_ENCRYPTED, DATA_PACKET, GPS, IP_PACKET, UDP_PACKET, SDM, ID_ANI, ID_UNIQUE});
        REGISTRATION = EnumSet.of(AFFILIATE, new DecodeEventType[]{AUTOMATIC_REGISTRATION_SERVICE, REGISTER, REGISTER_ESN, DEREGISTER, REQUEST, RESPONSE, RESPONSE_PACKET});
        OTHERS = EnumSet.copyOf(Arrays.stream(DecodeEventType.values()).filter(decodeEventType -> !decodeEventType.isGrouped()).toList());
    }
}

