/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.event;

import com.google.common.eventbus.Subscribe;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.module.decode.event.ClearableHistoryModel;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.sample.Listener;
import java.awt.EventQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecodeEventModel
extends ClearableHistoryModel<IDecodeEvent>
implements Listener<IDecodeEvent> {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(DecodeEventModel.class);
    public static final int COLUMN_TIME = 0;
    public static final int COLUMN_DURATION = 1;
    public static final int COLUMN_EVENT = 2;
    public static final int COLUMN_FROM_ID = 3;
    public static final int COLUMN_FROM_ALIAS = 4;
    public static final int COLUMN_TO_ID = 5;
    public static final int COLUMN_TO_ALIAS = 6;
    public static final int COLUMN_CHANNEL = 7;
    public static final int COLUMN_FREQUENCY = 8;
    public static final int COLUMN_DETAILS = 9;
    protected String[] mHeaders = new String[]{"Time", "Duration", "Event", "From", "Alias", "To", "Alias", "Channel", "Frequency", "Details"};

    public DecodeEventModel() {
        MyEventBus.getGlobalEventBus().register((Object)this);
    }

    @Subscribe
    public void preferenceUpdated(PreferenceType preferenceType) {
        if (preferenceType == PreferenceType.DECODE_EVENT || preferenceType == PreferenceType.TALKGROUP_FORMAT) {
            this.fireTableDataChanged();
        }
    }

    @Override
    public void receive(IDecodeEvent event) {
        EventQueue.invokeLater(() -> this.add(event));
    }

    @Override
    public int getColumnCount() {
        return this.mHeaders.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.mHeaders[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        IDecodeEvent event = (IDecodeEvent)this.getItem(rowIndex);
        if (event != null) {
            switch (columnIndex) {
                case 0: {
                    return event.getTimeStart();
                }
                case 1: {
                    return event.getDuration();
                }
                case 2: {
                    return event.getEventType().getLabel();
                }
                case 3: {
                    return event.getIdentifierCollection();
                }
                case 4: {
                    return event.getIdentifierCollection();
                }
                case 5: {
                    return event.getIdentifierCollection();
                }
                case 6: {
                    return event.getIdentifierCollection();
                }
                case 7: {
                    IChannelDescriptor channelDescriptor = event.getChannelDescriptor();
                    if (channelDescriptor != null) {
                        if (event.hasTimeslot()) {
                            return String.valueOf(channelDescriptor) + " TS:" + event.getTimeslot();
                        }
                        return channelDescriptor.toString();
                    }
                    if (event.hasTimeslot()) {
                        return "TS:" + event.getTimeslot();
                    }
                    return null;
                }
                case 8: {
                    return event.getChannelDescriptor();
                }
                case 9: {
                    return event.getDetails();
                }
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: 
            case 1: {
                return Long.class;
            }
            case 2: 
            case 9: {
                return String.class;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return IdentifierCollection.class;
            }
            case 7: {
                return String.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }
}

