/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.voice;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.BPTC_16_2;
import io.github.dsheirer.edac.Golay24;
import io.github.dsheirer.module.decode.dmr.message.IServiceOptionsProvider;
import io.github.dsheirer.module.decode.dmr.message.data.lc.full.FullLCMessage;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceEMBMessage;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceMessage;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.EmbeddedParameters;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.EncryptionParameters;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.NonStandardShortBurst;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.NullShortBurst;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.ShortBurst;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.ShortBurstOpcode;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.TransmitInterrupt;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.UnknownShortBurst;

public class VoiceSuperFrameProcessor {
    private static final int[] IV = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] CRC4 = new int[]{56, 57, 58, 59};
    private boolean mEncrypted = false;
    private byte[] mFragmentA;
    private byte[] mFragmentB;
    private byte[] mFragmentC;
    private byte[] mFragmentD;
    private byte[] mFragmentE;

    public boolean isCollecting() {
        return this.mEncrypted;
    }

    public void reset() {
        this.mEncrypted = false;
        this.softReset();
    }

    private void softReset() {
        this.mFragmentA = null;
        this.mFragmentB = null;
        this.mFragmentC = null;
        this.mFragmentD = null;
        this.mFragmentE = null;
    }

    private boolean isComplete() {
        return this.mEncrypted && this.mFragmentA != null && this.mFragmentB != null && this.mFragmentC != null && this.mFragmentD != null && this.mFragmentE != null;
    }

    public void process(FullLCMessage flc) {
        IServiceOptionsProvider provider;
        if (flc instanceof IServiceOptionsProvider && (provider = (IServiceOptionsProvider)((Object)flc)).getServiceOptions().isEncrypted()) {
            this.mEncrypted = true;
        }
    }

    public void process(VoiceMessage voiceMessage) {
        VoiceEMBMessage voiceEMB;
        if (voiceMessage instanceof VoiceEMBMessage && (voiceEMB = (VoiceEMBMessage)voiceMessage).getEMB().isValid() && voiceEMB.getEMB().isEncrypted()) {
            this.mEncrypted = true;
        }
        switch (voiceMessage.getSyncPattern()) {
            case BASE_STATION_VOICE: {
                this.mFragmentA = voiceMessage.getIvFragments();
                break;
            }
            case BS_VOICE_FRAME_B: {
                this.mFragmentB = voiceMessage.getIvFragments();
                break;
            }
            case BS_VOICE_FRAME_C: {
                this.mFragmentC = voiceMessage.getIvFragments();
                break;
            }
            case BS_VOICE_FRAME_D: {
                this.mFragmentD = voiceMessage.getIvFragments();
                break;
            }
            case BS_VOICE_FRAME_E: {
                this.mFragmentE = voiceMessage.getIvFragments();
                break;
            }
            case BS_VOICE_FRAME_F: {
                if (voiceMessage instanceof VoiceEMBMessage) {
                    VoiceEMBMessage voiceFrame6 = (VoiceEMBMessage)voiceMessage;
                    BinaryMessage frameFFragment = voiceFrame6.getFLCFragment();
                    ShortBurst shortBurst = this.extractShortBurst(frameFFragment);
                    EmbeddedParameters embeddedParameters = new EmbeddedParameters(shortBurst);
                    if (this.isComplete()) {
                        String iv = this.extractIV(voiceMessage.getIvFragments());
                        embeddedParameters.setIv(iv);
                    }
                    voiceFrame6.setEmbeddedParameters(embeddedParameters);
                }
                this.softReset();
            }
        }
    }

    private ShortBurst extractShortBurst(BinaryMessage frameFFragment) {
        CorrectedBinaryMessage decoded = BPTC_16_2.decodeShortBurst(new CorrectedBinaryMessage(frameFFragment));
        if (decoded == null) {
            return new NonStandardShortBurst(BPTC_16_2.deinterleave(new CorrectedBinaryMessage(frameFFragment)));
        }
        ShortBurstOpcode opcode = ShortBurst.getOpcode(decoded);
        return switch (opcode) {
            case ShortBurstOpcode.NULL -> new NullShortBurst(decoded);
            case ShortBurstOpcode.ARC4_ENCRYPTION, ShortBurstOpcode.AES128_ENCRYPTION, ShortBurstOpcode.AES256_ENCRYPTION -> new EncryptionParameters(decoded);
            case ShortBurstOpcode.TXI_DELAY -> new TransmitInterrupt(decoded);
            default -> new UnknownShortBurst(decoded);
        };
    }

    private String extractIV(byte[] mFragmentF) {
        int checksum;
        CorrectedBinaryMessage reassembled = new CorrectedBinaryMessage(72);
        reassembled.setByte(0, this.combine(this.mFragmentA[0], this.mFragmentB[0]));
        reassembled.setByte(8, this.combine(this.mFragmentC[0], this.mFragmentD[0]));
        reassembled.setByte(16, this.combine(this.mFragmentE[0], mFragmentF[0]));
        reassembled.setByte(24, this.combine(this.mFragmentA[1], this.mFragmentB[1]));
        reassembled.setByte(32, this.combine(this.mFragmentC[1], this.mFragmentD[1]));
        reassembled.setByte(40, this.combine(this.mFragmentE[1], mFragmentF[1]));
        reassembled.setByte(48, this.combine(this.mFragmentA[2], this.mFragmentB[2]));
        reassembled.setByte(56, this.combine(this.mFragmentC[2], this.mFragmentD[2]));
        reassembled.setByte(64, this.combine(this.mFragmentE[2], mFragmentF[2]));
        int check1 = Golay24.checkAndCorrect(reassembled, 0);
        int check2 = Golay24.checkAndCorrect(reassembled, 24);
        int check3 = Golay24.checkAndCorrect(reassembled, 48);
        if (check1 == 2 || check2 == 2 || check3 == 2) {
            return null;
        }
        int iv = reassembled.getInt(IV);
        boolean passes = VoiceSuperFrameProcessor.crc4(iv, checksum = reassembled.getInt(CRC4));
        if (passes) {
            return String.format("%08X", iv);
        }
        return String.format("%08X", iv) + "(CRC-FAIL " + check1 + "/" + check2 + "/" + check3 + "/" + reassembled.getCorrectedBitCount() + ")";
    }

    private byte combine(byte high, byte low) {
        return (byte)((high & 0xF) << 4 | low & 0xF);
    }

    public static boolean crc4(int value, int crc) {
        long checksum = ((long)value & 0xFFFFFFFFL) << 4;
        checksum ^= 0xFL;
        long polynomial = 0x980000000L;
        long checkBit = 0x800000000L;
        for (int x = 31; x >= 0; --x) {
            if ((checksum & checkBit) == checkBit) {
                checksum ^= polynomial;
            }
            polynomial >>= 1;
            checkBit >>= 1;
        }
        return (int)checksum == crc;
    }
}

