/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.voice;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.DMRSyncPattern;
import io.github.dsheirer.module.decode.dmr.message.CACH;
import io.github.dsheirer.module.decode.dmr.message.voice.EMB;
import io.github.dsheirer.module.decode.dmr.message.voice.VoiceMessage;
import io.github.dsheirer.module.decode.dmr.message.voice.embedded.EmbeddedParameters;

public class VoiceEMBMessage
extends VoiceMessage {
    private static final int[] EMB = new int[]{132, 133, 134, 135, 136, 137, 138, 139, 172, 173, 174, 175, 176, 177, 178, 179};
    private static final int PAYLOAD_START = 140;
    private static final int PAYLOAD_END = 172;
    private EMB mEMB;
    private EmbeddedParameters mEmbeddedParameters;

    public VoiceEMBMessage(DMRSyncPattern syncPattern, CorrectedBinaryMessage message, CACH cach, long timestamp, int timeslot) {
        super(syncPattern, message, cach, timestamp, timeslot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.getSyncPattern().isMobileSyncPattern() && this.getEMB().isValid()) {
            sb.append("CC:").append(this.getEMB().getColorCode()).append(" ");
        }
        sb.append(this.getSyncPattern().toString());
        if (this.hasEmbeddedParameters()) {
            sb.append(" ").append(this.getEmbeddedParameters());
        } else if (this.getEMB().isValid() && this.getEMB().isEncrypted()) {
            sb.append(" ENCRYPTED");
        }
        return sb.toString();
    }

    public EMB getEMB() {
        if (this.mEMB == null) {
            CorrectedBinaryMessage segment = new CorrectedBinaryMessage(16);
            for (int x = 0; x < EMB.length; ++x) {
                segment.set(x, this.getMessage().get(EMB[x]));
            }
            this.mEMB = new EMB(segment);
        }
        return this.mEMB;
    }

    public BinaryMessage getFLCFragment() {
        return this.getMessage().getSubMessage(140, 172);
    }

    public EmbeddedParameters getEmbeddedParameters() {
        return this.mEmbeddedParameters;
    }

    public void setEmbeddedParameters(EmbeddedParameters embeddedParameters) {
        this.mEmbeddedParameters = embeddedParameters;
    }

    public boolean hasEmbeddedParameters() {
        return this.mEmbeddedParameters != null;
    }
}

