/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.voice;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.message.type.LCSS;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EMB {
    private static final Logger mLog = LoggerFactory.getLogger(EMB.class);
    private static final int[] VALID_WORDS = new int[]{0, 627, 1253, 1686, 2505, 3002, 3372, 3935, 4578, 5009, 5383, 6004, 6187, 6744, 7374, 7869, 8631, 9156, 9554, 10017, 10366, 10765, 11419, 12008, 12373, 12838, 13488, 14019, 14748, 15343, 15737, 16138, 16670, 17261, 17915, 18312, 18647, 19108, 19506, 20033, 20732, 21135, 21529, 22122, 22837, 23366, 24016, 24483, 24745, 25306, 25676, 26175, 26976, 27411, 28037, 28662, 29003, 29496, 30126, 30685, 30850, 31473, 31847, 32276, 32815, 33372, 33994, 34489, 35302, 35733, 36099, 36720, 37325, 37822, 38184, 38747, 38916, 39543, 40161, 40594, 41368, 41963, 42365, 42766, 43089, 43554, 44212, 44743, 45178, 45577, 46239, 46828, 47539, 48064, 48470, 48933, 49457, 49986, 50644, 51111, 51448, 51851, 52253, 52846, 53459, 53920, 54326, 54853, 55578, 56169, 56831, 57228, 57478, 58101, 58467, 58896, 59727, 60220, 60842, 61401, 61796, 62231, 62849, 63474, 63661, 64222, 64584, 65083};
    private static final HashSet<Integer> WORD_SET = new HashSet();
    private static final int[] WORD;
    private static final int[] COLOR_CODE;
    private static final int ENCRYPTION_PI = 4;
    private static final int[] LINK_CONTROL_START_STOP;
    private CorrectedBinaryMessage mMessage;
    private boolean mValid = true;

    public EMB(CorrectedBinaryMessage message) {
        this.mMessage = message;
        this.checkCRC();
    }

    private void checkCRC() {
        int word = this.getMessage().getInt(WORD);
        if (WORD_SET.contains(word)) {
            this.mValid = true;
            return;
        }
        int bitErrors = 0;
        for (int validWord : VALID_WORDS) {
            bitErrors = Integer.bitCount(word ^ validWord);
            if (bitErrors > 3) continue;
            this.getMessage().setInt(validWord, WORD);
            this.getMessage().setCorrectedBitCount(bitErrors);
            this.mValid = bitErrors <= 1;
            return;
        }
        this.mValid = false;
    }

    public boolean isValid() {
        return this.mValid;
    }

    protected CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public int getColorCode() {
        return this.getMessage().getInt(COLOR_CODE);
    }

    public LCSS getLCSS() {
        return LCSS.fromValue(this.getMessage().getInt(LINK_CONTROL_START_STOP));
    }

    public boolean isEncrypted() {
        return this.getMessage().get(4);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" EMB-");
        sb.append(this.isEncrypted() ? "EN" : "UN");
        sb.append((Object)this.getLCSS());
        sb.append("CC:").append(this.getColorCode());
        return sb.toString();
    }

    public static void main(String[] args) {
        CorrectedBinaryMessage m = new CorrectedBinaryMessage(16);
        int x = 0;
        while ((double)x < Math.pow(2.0, 16.0)) {
            m.setInt(x, WORD);
            EMB emb = new EMB(m);
            if (!emb.isValid()) {
                mLog.debug("Invalid: " + x);
            }
            ++x;
        }
    }

    static {
        for (int word : VALID_WORDS) {
            WORD_SET.add(word);
        }
        WORD = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        COLOR_CODE = new int[]{0, 1, 2, 3};
        LINK_CONTROL_START_STOP = new int[]{5, 6};
    }
}

