/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.type;

import java.util.Map;
import java.util.TreeMap;

public enum Vendor {
    STANDARD(0, "STANDARD"),
    FYLDE_MICRO(4, "FYLDE MICRO"),
    PROD_EL_SPA(5, "PROD-EL SPA"),
    MOTOROLA_CONNECT_PLUS(6, "MOTOROLA CON+"),
    RADIO_DATA_GMBH(7, "RADIO DATA GMBH"),
    HYTERA_8(8, "HYTERA"),
    ASELSAN(9, "ASELSAN"),
    KIRISUN(10, "KIRISUN"),
    DMR_ASSOCIATION(11, "DMR ASSOCIATION"),
    SEPURA(12, "SEPURA"),
    ITALIA_RED_CROSS(13, "ITALIA RED CROSS"),
    MOTOROLA_CAPACITY_PLUS(16, "MOTOROLA CAP+"),
    MINISTERO_DELL_INTERNO(19, "ITALY MIN INTERIOR"),
    EMC_COMM_SRL_28(28, "EMC COMM SRL 28"),
    EMC_COMM_SRL_32(32, "EMC COMM SRL 32"),
    JVC_KENWOOD(51, "JVC-KENWOOD"),
    RADIO_ACTIVITY_SRL(60, "RADIO ACTIVITY SRL"),
    ZTE_TRUNKING(84, "ZTE TRUNKING"),
    TAIT(88, "TAIT"),
    HYTERA_68(104, "HYTERA"),
    VERTEX_STANDARD(119, "VERTEX STANDARD"),
    SIMOCO(120, "SIMOCO"),
    TEST(121, "TEST"),
    HYTERA_88(136, "HYTERA"),
    UNKNOWN(-1, "UNKNOWN");

    private int mValue;
    private String mLabel;
    private static final Map<Integer, Vendor> LOOKUP_MAP;

    private Vendor(int value, String label) {
        this.mValue = value;
        this.mLabel = label;
    }

    public int getValue() {
        return this.mValue;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public String toString() {
        return this.getLabel();
    }

    public static Vendor fromValue(int value) {
        if (LOOKUP_MAP.containsKey(value)) {
            return LOOKUP_MAP.get(value);
        }
        return UNKNOWN;
    }

    static {
        LOOKUP_MAP = new TreeMap<Integer, Vendor>();
        for (Vendor vendor : Vendor.values()) {
            LOOKUP_MAP.put(vendor.getValue(), vendor);
        }
    }
}

