/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.type;

public enum Tier3Gateway {
    PSTNI(16776896, "PSTN GATEWAY"),
    PABXI(16776897, "PABX GATEWAY"),
    LINEI(16776898, "LINE GATEWAY"),
    IPI(16776899, "IP GATEWAY"),
    SUPLI(16776900, "SUPPLEMENTARY DATA SERVICE"),
    SDMI(16776901, "UDT SHORT DATA SERVICE"),
    REGI(16776902, "REGISTRATION SERVICE"),
    MSI(16776903, "CALL DIVERSION TO MS GATEWAY"),
    DIVERTI(16776905, "CALL DIVERSION CANCELLATION"),
    TSI(16776906, "TRUNKING SYSTEM CONTROLLER"),
    DISPATI(16776907, "SYSTEM DISPATCHER"),
    STUNI(0xFFFECC, "MS STUN/REVIVE"),
    AUTHI(16776909, "AUTHENTICATION"),
    GPI(0xFFFECE, "CALL DIVERSION TO TALKGROUP GATEWAY"),
    KILLI(0xFFFECF, "MS KILL"),
    PSTNDI(16776912, "PSTN-D GATEWAY"),
    PABXDI(16776913, "PABX-D GATEWAY"),
    LINEDI(16776914, "LINE-D GATEWAY"),
    DISPATDI(16776915, "SYSTEM DISPATCHER-D"),
    ALLMSI(16776916, "ALL RADIOS/TALKGROUPS"),
    IPDI(16776917, "IP-D GATEWAY"),
    DGNAI(16776918, "DYNAMIC GROUP NUMBER ASSIGNMENT"),
    TATTSI(16776919, "TALKGROUP SUBSCRIBE/ATTACH SERVICE"),
    ALLMSIDL(0xFFFFFD, "ALL RADIOS AT SITE"),
    ALLMSIDZ(0xFFFFFE, "ALL RADIOS IN ZONE"),
    ALLMSID(0xFFFFFF, "ALL RADIOS IN SYSTEM"),
    RESERVED(0, "RESERVED");

    private int mValue;
    private String mLabel;

    private Tier3Gateway(int value, String label) {
        this.mValue = value;
        this.mLabel = label;
    }

    public static boolean isGateway(int value) {
        if (value >= PSTNI.getValue()) {
            for (Tier3Gateway gateway : Tier3Gateway.values()) {
                if (!gateway.matches(value)) continue;
                return true;
            }
        }
        return false;
    }

    public static Tier3Gateway fromValue(int value) {
        for (Tier3Gateway gateway : Tier3Gateway.values()) {
            if (!gateway.matches(value)) continue;
            return gateway;
        }
        return RESERVED;
    }

    public boolean matches(int value) {
        return this.mValue == value;
    }

    public int getValue() {
        return this.mValue;
    }

    public String getLabel() {
        return this.mLabel;
    }
}

