/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.type;

public class ResponseStatus {
    private int mValue;

    public ResponseStatus(int value) {
        this.mValue = value;
    }

    public Status getStatus() {
        return Status.fromValue(this.mValue);
    }

    public int getType() {
        return (this.mValue & 0x38) >> 3;
    }

    public int getValue() {
        return this.mValue & 7;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        block0 : switch (this.getStatus()) {
            case ACK: {
                sb.append("SUCCESS - ALL BLOCKS THRU ").append(this.getValue()).append(" RECEIVED");
                break;
            }
            case NACK: {
                switch (this.getType()) {
                    case 0: {
                        sb.append("FAIL - ILLEGAL FORMAT - LAST VALID FSN:").append(this.getValue());
                        break block0;
                    }
                    case 1: {
                        sb.append("FAIL - PACKET CRC FAIL - LAST VALID FSN:").append(this.getValue());
                        break block0;
                    }
                    case 2: {
                        sb.append("FAIL - RECIPIENT MEMORY FULL - LAST VALID FSN:").append(this.getValue());
                        break block0;
                    }
                    case 3: {
                        sb.append("FAIL - OUT OF SEQUENCE FSN:").append(this.getValue());
                        break block0;
                    }
                    case 4: {
                        sb.append("FAIL - UNDELIVERABLE - LAST VALID FSN:").append(this.getValue());
                        break block0;
                    }
                    case 5: {
                        sb.append("FAIL - PACKET OUT OF SEQUENCE - LAST VALID FSN:").append(this.getValue());
                        break block0;
                    }
                    case 6: {
                        sb.append("FAIL - INVALID USER ON THIS SYSTEM");
                        break block0;
                    }
                }
                sb.append("FAIL - UNKNOWN TYPE [").append(this.getType()).append("] VALUE [").append(this.getValue()).append("]");
                break;
            }
            case SACK: {
                sb.append("SELECTIVE RETRY - LAST VALID FSN:").append(this.getValue());
                break;
            }
            case RESERVED: {
                sb.append("UNKNOWN/RESERVED WITH TYPE [").append(this.getType()).append("] VALUE [").append(this.getValue()).append("]");
            }
        }
        return sb.toString();
    }

    private static enum Status {
        ACK,
        NACK,
        SACK,
        RESERVED;


        public static Status fromValue(int value) {
            int masked = (value & 0xC0) >> 6;
            if (0 <= masked && masked <= 2) {
                return Status.values()[masked];
            }
            return RESERVED;
        }
    }
}

