/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.type;

import java.util.Map;
import java.util.TreeMap;

public enum Reason {
    MS_SERVICE_NOT_SUPPORTED(0, "SERVICE_NOT SUPPORTED"),
    MS_LINE_NOT_SUPPORTED(17, "LINE NOT SUPPORTED"),
    MS_REFUSED_STACK_FULL(18, "MS REFUSED - STACK FULL"),
    MS_REFUSED_EQUIPMENT_BUSY(19, "MS REFUSED - EQUIPMENT BUSY"),
    MS_REFUSED_BY_RECIPIENT(20, "REFUSED BY RECIPIENT"),
    MS_REFUSED_CUSTOM(21, "REFUSED-CUSTOM"),
    MS_DUPLEX_NOT_SUPPORTED(22, "DUPLEX NOT SUPPORTED BY MS"),
    MS_REFUSED_REASON_UNKNOWN(31, "REFUSED-REASON UNKNOWN"),
    TS_SERVICE_NOT_SUPPORTED(32, "SERVICE NOT SUPPORTED"),
    TS_REFUSED_NOT_PERMITTED(33, "REFUSED-NOT PERMISSION"),
    TS_REFUSED_SERVICE_TEMP_UNAVAILABLE(34, "REFUSED-SERVICE TEMPORARY UNAVAILABLE"),
    TS_REFUSED_SERVICE_UNAVAILABLE(35, "REFUSED-SERVICE UNAVAILABLE"),
    TS_REFUSED_CALLED_RADIO_NOT_REGISTERED(36, "REFUSED-CALLED RADIO NOT REGISTERED"),
    TS_REFUSED_CALLED_RADIO_OFFLINE(37, "REFUSED-CALLED RADIO OFFLINE"),
    TS_REFUSED_CALLED_RADIO_CALL_DIVERT(38, "REFUSED-CALLED RADIO HAS CALL DIVERSION"),
    TS_REFUSED_NETWORK_CONGESTION(39, "REFUSED-NETWORK CONGESTION"),
    TS_REFUSED_NETWORK_NOT_READY(40, "REFUSED-NETWORK NOT READY"),
    TS_REFUSED_CANNOT_CANCEL_CALL(41, "REFUSED-CANNOT CANCEL CALL"),
    TS_REGISTRATION_REFUSED(42, "REGISTRATION REFUSED"),
    TS_REGISTRATION_DENIED(43, "REGISTRATION DENIED"),
    TS_IP_CONNECTION_FAILED(44, "IP CONNECTION FAILED"),
    TS_REFUSED_RADIO_NOT_REGISTERED(45, "REFUSED-RADIO NOT REGISTERED"),
    TS_CALLED_PARTY_BUSY(46, "CALLED PARTY BUSY"),
    TS_CALLED_TALKGROUP_NOT_ALLOWED(47, "CALLED TALKGROUP NOT ALLOWED"),
    TS_CRC_ERROR_IN_UDT_UPLOAD(48, "CRC ERROR IN UDT UPLOAD"),
    TS_REFUSED_DUPLEX_CALL_NETWORK_CONGESTION(49, "REFUSED DUPLEX CALL-NETWORK CONGESTION"),
    TS_REFUSED_REASON_UNKNOWN(63, "REFUSED-REASON UNKNONW"),
    MS_MESSAGE_ACCEPTED(68, "MESSAGE ACCEPTED"),
    MS_CALLBACK(69, "CALLBACK"),
    MS_ALERTING(70, "ALERTING BUT NOT READY"),
    MS_ACCEPTED_FOR_POLLING_STATUS_SERVICE(71, "ACCEPTED FOR POLLING STATUS SERVICE"),
    MS_AUTHENTICATION_RESPONSE(72, "AUTHENTICATION RESPONSE"),
    TS_MESSAGE_ACCEPTED(96, "MESSAGE ACCEPTED"),
    TS_STORE_AND_FORWARD(97, "STORE AND FORWARD"),
    TS_REGISTRATION_ACCEPTED(98, "REGISTRATION ACCEPTED"),
    TS_ACCEPTED_FOR_STATUS_POLLING_SERVICE(99, "ACCEPTED FOR STATUS POLLING SERVICE"),
    TS_AUTHENTICATION_RESPONSE(100, "AUTHENTICATION RESPONSE"),
    TS_SUBSCRIPTION_SERVICE_REGISTRATION_ACCEPTED(101, "SUBSCRIPTION SERVICE REGISTRATION ACCEPTED"),
    TS_QUEUED_FOR_RESOURCE(160, "QUEUED FOR RESOURCE"),
    TS_QUEUED_FOR_BUSY_RADIO(170, "QUEUED FOR BUSY RADIO"),
    TS_WAIT(224, "WAIT"),
    UNKNOWN(-1, "UNKNOWN");

    private int mValue;
    private String mLabel;
    private static final Map<Integer, Reason> LOOKUP_MAP;

    private Reason(int value, String label) {
        this.mValue = value;
        this.mLabel = label;
    }

    public int getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mLabel;
    }

    public static Reason fromValue(int value) {
        if (LOOKUP_MAP.containsKey(value)) {
            return LOOKUP_MAP.get(value);
        }
        return UNKNOWN;
    }

    static {
        LOOKUP_MAP = new TreeMap<Integer, Reason>();
        for (Reason reason : Reason.values()) {
            LOOKUP_MAP.put(reason.getValue(), reason);
        }
    }
}

