/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.type;

public enum EncryptionAlgorithm {
    NO_ENCRYPTION(0, "NO ENCRYPTION"),
    HYTERA_BASIC_PRIVACY(1, "HYTERA BP"),
    HYTERA_ENHANCED_PRIVACY(2, "HYTERA RC4/EP"),
    DMRA_RC4(33, "DMRA RC4/EP"),
    DMRA_AES128(36, "DMRA AES128"),
    DMRA_AES256(37, "DMRA AES256"),
    HYTERA_ENHANCED_PRIVACY_2(38, "HYTERA RC4/EP"),
    UNKNOWN(-1, "UNKNOWN");

    private final int mValue;
    private final String mLabel;

    private EncryptionAlgorithm(int value, String label) {
        this.mValue = value;
        this.mLabel = label;
    }

    public int getValue() {
        return this.mValue;
    }

    public static EncryptionAlgorithm fromValue(int value) {
        for (EncryptionAlgorithm algorithm : EncryptionAlgorithm.values()) {
            if (algorithm.getValue() != value) continue;
            return algorithm;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.mLabel;
    }
}

