/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.type;

public enum DataPacketFormat {
    UNIFIED_DATA_TRANSPORT(0, "UNIFIED DATA TRANSPORT"),
    RESPONSE_PACKET(1, "RESPONSE PACKET"),
    UNCONFIRMED_DATA_PACKET(2, "UNCONFIRMED DATA PACKET"),
    CONFIRMED_DATA_PACKET(3, "CONFIRMED DATA PACKET"),
    DEFINED_SHORT_DATA(13, "DEFINED SHORT DATA"),
    RAW_OR_STATUS_SHORT_DATA(14, "RAW OR STATUS SHORT DATA"),
    PROPRIETARY_DATA_PACKET(15, "PROPRIETARY DATA PACKET"),
    UNKNOWN(-1, "UNKNOWN");

    private int mValue;
    private String mLabel;

    private DataPacketFormat(int value, String label) {
        this.mValue = value;
        this.mLabel = label;
    }

    public int getValue() {
        return this.mValue;
    }

    public String toString() {
        return this.mLabel;
    }

    public static DataPacketFormat fromValue(int value) {
        switch (value) {
            case 0: {
                return UNIFIED_DATA_TRANSPORT;
            }
            case 1: {
                return RESPONSE_PACKET;
            }
            case 2: {
                return UNCONFIRMED_DATA_PACKET;
            }
            case 3: {
                return CONFIRMED_DATA_PACKET;
            }
            case 13: {
                return DEFINED_SHORT_DATA;
            }
            case 14: {
                return RAW_OR_STATUS_SHORT_DATA;
            }
            case 15: {
                return PROPRIETARY_DATA_PACKET;
            }
        }
        return UNKNOWN;
    }
}

