/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.type;

import com.google.common.base.Joiner;
import io.github.dsheirer.module.decode.dmr.message.type.ServiceOptions;
import java.util.ArrayList;

public class CapacityPlusServiceOptions
extends ServiceOptions {
    public CapacityPlusServiceOptions(int value) {
        super(value);
    }

    public boolean isCapacityPlus() {
        return !this.isReserved1();
    }

    public boolean isInterruptible() {
        return this.isReserved2();
    }

    @Override
    public String toString() {
        ArrayList<Object> flags = new ArrayList<Object>();
        if (this.isEmergency()) {
            flags.add("EMERGENCY");
        }
        if (this.isEncrypted()) {
            flags.add("ENCRYPTED");
        }
        if (this.isBroadcastService()) {
            flags.add("BROADCAST");
        }
        if (this.isOpenVoiceCallMode()) {
            flags.add("OVCM");
        }
        if (this.isInterruptible()) {
            flags.add("INTERRUPTIBLE CALL");
        }
        if (this.getPriority() > 0) {
            flags.add("PRIORITY-" + this.getPriority());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SERVICE OPTIONS [");
        if (!flags.isEmpty()) {
            sb.append(Joiner.on((String)",").join(flags));
        }
        sb.append("]");
        return sb.toString();
    }
}

