/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.type;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.dmr.channel.DMRAbsoluteChannel;
import io.github.dsheirer.module.decode.dmr.message.type.AbstractStructure;

public class AbsoluteChannelParameters
extends AbstractStructure {
    private static final int LAST_BLOCK_FLAG = 0;
    private static final int ENCRYPTION_FLAG = 1;
    private static final int[] OPCODE = new int[]{2, 3, 4, 5, 6, 7};
    private static final int[] COLOR_CODE = new int[]{12, 13, 14, 15};
    private static final int[] CDEF_TYPE = new int[]{16, 17, 18, 19};
    private static final int[] LCN = new int[]{22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33};
    private static final int[] UPLINK_FREQUENCY_MHZ = new int[]{34, 35, 36, 37, 38, 39, 40, 41, 42, 43};
    private static final int[] UPLINK_FREQUENCY_125_HZ = new int[]{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56};
    private static final int[] DOWNLINK_FREQUENCY_MHZ = new int[]{57, 58, 59, 60, 61, 62, 63, 64, 65, 66};
    private static final int[] DOWNLINK_FREQUENCY_125_HZ = new int[]{67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private DMRAbsoluteChannel mChannel;
    private int mTimeslot;

    public AbsoluteChannelParameters(CorrectedBinaryMessage message, int offset, int timeslot) {
        super(message, offset);
        this.mTimeslot = timeslot;
    }

    public DMRAbsoluteChannel getChannel() {
        if (this.mChannel == null) {
            this.mChannel = new DMRAbsoluteChannel(this.getChannelNumber(), this.mTimeslot, this.getDownlinkFrequency(), this.getUplinkFrequency());
        }
        return this.mChannel;
    }

    public int getColorCode() {
        return this.getMessage().getInt(COLOR_CODE, this.getOffset());
    }

    public boolean isLastBlock() {
        return this.getMessage().get(0 + this.getOffset());
    }

    public boolean isEncrypted() {
        return this.getMessage().get(1 + this.getOffset());
    }

    public int getOpcodeValue() {
        return this.getMessage().getInt(OPCODE);
    }

    public int getChannelNumber() {
        return this.getMessage().getInt(LCN, this.getOffset());
    }

    public long getUplinkFrequency() {
        long frequency = (long)((double)this.getMessage().getInt(UPLINK_FREQUENCY_MHZ, this.getOffset()) * 1000000.0);
        return frequency += (long)(this.getMessage().getInt(UPLINK_FREQUENCY_125_HZ) * 125);
    }

    public long getDownlinkFrequency() {
        long frequency = (long)((double)this.getMessage().getInt(DOWNLINK_FREQUENCY_MHZ, this.getOffset()) * 1000000.0);
        return frequency += (long)(this.getMessage().getInt(DOWNLINK_FREQUENCY_125_HZ) * 125);
    }
}

