/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.message.data.packet.DMRPacketMessage;
import io.github.dsheirer.module.decode.dmr.message.data.packet.UDTShortMessageService;
import io.github.dsheirer.module.decode.ip.hytera.sds.HyteraUnknownPacket;
import io.github.dsheirer.module.decode.ip.hytera.sms.HyteraSmsPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.ars.ARSPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.lrrp.LRRPPacket;
import io.github.dsheirer.module.decode.ip.mototrbo.xcmp.XCMPPacket;
import java.util.function.Function;

public class DmrPacketSequenceFilter
extends Filter<IMessage, String> {
    private static final String KEY_ARS = "Automatic Registration Service (ARS)";
    private static final String KEY_HYTERA_SMS = "Hytera Short Message Service (SMS)";
    private static final String KEY_HYTERA_UNKNOWN = "Hytera Unknown";
    private static final String KEY_LRRP = "Location Request/Response Protocol (LRRP)";
    private static final String KEY_UDT_SMS = "Unified Data Transport - Short Message Service";
    private static final String KEY_XCMP = "Extensible Command Message Protocol (XCMP)";
    private static final String KEY_UNKNOWN = "Other/Unknown";
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public DmrPacketSequenceFilter() {
        super("Packet Sequence Messages");
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof DMRPacketMessage && super.canProcess(message);
    }

    @Override
    public Function<IMessage, String> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, String> {
        private KeyExtractor(DmrPacketSequenceFilter dmrPacketSequenceFilter) {
        }

        @Override
        public String apply(IMessage message) {
            if (message instanceof UDTShortMessageService) {
                return DmrPacketSequenceFilter.KEY_UDT_SMS;
            }
            if (message instanceof DMRPacketMessage) {
                DMRPacketMessage packetMessage = (DMRPacketMessage)message;
                if (packetMessage.getPacket() instanceof ARSPacket) {
                    return DmrPacketSequenceFilter.KEY_ARS;
                }
                if (packetMessage.getPacket() instanceof LRRPPacket) {
                    return DmrPacketSequenceFilter.KEY_LRRP;
                }
                if (packetMessage.getPacket() instanceof XCMPPacket) {
                    return DmrPacketSequenceFilter.KEY_XCMP;
                }
                if (packetMessage.getPacket() instanceof HyteraSmsPacket) {
                    return DmrPacketSequenceFilter.KEY_HYTERA_SMS;
                }
                if (packetMessage.getPacket() instanceof HyteraUnknownPacket) {
                    return DmrPacketSequenceFilter.KEY_HYTERA_UNKNOWN;
                }
            }
            return DmrPacketSequenceFilter.KEY_UNKNOWN;
        }
    }
}

