/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.dmr.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.dmr.message.DMRMessage;
import java.util.function.Function;

public class DmrOtherMessageFilter
extends Filter<IMessage, String> {
    private static final String OTHER_KEY = "Other/Unknown Message";
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public DmrOtherMessageFilter() {
        super("Other DMR messages");
        this.add(new FilterElement<String>(OTHER_KEY));
    }

    @Override
    public Function<IMessage, String> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof DMRMessage && super.canProcess(message);
    }

    private class KeyExtractor
    implements Function<IMessage, String> {
        private KeyExtractor(DmrOtherMessageFilter dmrOtherMessageFilter) {
        }

        @Override
        public String apply(IMessage message) {
            if (message instanceof DMRMessage) {
                return DmrOtherMessageFilter.OTHER_KEY;
            }
            return null;
        }
    }
}

